/* 
Digital Watch
Date: March 18th, 1996
Code: Pronto (pronto@forex.ee)
Copyright (c) 1996, Deus Ex Machina
*/

import java.awt.*;
import java.util.*;


public class DigitalWatch extends java.applet.Applet implements Runnable {
	Graphics	offScreenGraphics;
	Image		offScreenImage;
	Thread		timer = null;
	Image		watchImage;
	MediaTracker	tracker;

	public void init() {
		int	tempx, tempy;
		Dimension d = size();

		tracker = new MediaTracker(this);

		resize(172, 251);
		watchImage = getImage(getCodeBase(), "images/TIMEX.gif");
		tracker.addImage(watchImage, 0);
		offScreenImage = createImage(d.width, d.height);
		offScreenGraphics = offScreenImage.getGraphics();
		offScreenGraphics.setColor(Color.lightGray);
                offScreenGraphics.fillRect(49, 111, 75, 21);
	}

	public void paint(Graphics g) {
		int	theBit, theLine;
		int	x, y;
		int 	s, m, h;
		int	charCounter;
		int	secSize;
		int	myChar;
		String	formattedTime = "";
		Date	watchTime = new Date();
                int itsData[][] = {
                        {14, 17, 25, 21, 19, 17, 14}, // 0
                        { 4,  6,  4,  4,  4,  4, 14}, // 1
                        {14, 17, 16,  8,  4,  2, 31}, // 2
                        {31,  8,  4,  8, 16, 17, 14}, // 3
                        { 8, 12, 10,  9, 31,  8,  8}, // 4
                        {31,  1, 15, 16, 16, 17, 14}, // 5
                        {12,  2,  1, 15, 17, 17, 14}, // 6
                        {31, 16,  8,  4,  2,  2,  2}, // 7
                        {14, 17, 17, 14, 17, 17, 14}, // 8
                        {14, 17, 17, 30, 16,  8,  6}, // 9
                        { 0,  6,  6,  0,  6,  6,  0}  // :
                };
		
		s = watchTime.getSeconds();
		m = watchTime.getMinutes();
		h = watchTime.getHours();

		formattedTime = formattedTime.concat(padElement(h, '0'));
		formattedTime = formattedTime.concat(String.valueOf(':'));
		formattedTime = formattedTime.concat(padElement(m, '0'));
		formattedTime = formattedTime.concat(padElement(s, '0'));

                offScreenGraphics.drawImage(watchImage, 0, 0, this);
                
		for (charCounter = 0; charCounter < 7; charCounter++) {
		if (charCounter > 4) secSize = 1; else secSize = 2;
		myChar = ((int) formattedTime.charAt(charCounter)) - 0x30;
		for (y = 0; y < 7; y++) {
                        theLine = itsData[myChar][y];
			for (x = 0; x < 6; x++) {
				theBit = theLine >> x;
				if ((theBit & 1) == 1) {
					offScreenGraphics.setColor(Color.black);
				}
				else {
					offScreenGraphics.setColor(Color.lightGray);
				}
                                if (secSize == 2)
                                offScreenGraphics.fillRect(x * 2 + (charCounter * 12) + 49, (y * 3) + 111, 2, 2);
                                else
                                offScreenGraphics.fillRect(x + (charCounter * 6) + 81, (y * 2) + 111, 2, 2);
			}
		}
		}
		if (tracker.statusID(0, true) == MediaTracker.COMPLETE)
                g.drawImage(offScreenImage, 0, 0, this);
	}

	public void update(Graphics g) {
		paint(g);
	}
	
	public void run() {
		while (timer != null) {
  			try {
				timer.sleep(100);
			} 
			catch (InterruptedException e) {}
  			repaint(); 
		}
	timer = null;
	}

	public void start() {
		if (timer == null) {
			timer = new Thread(this);
			timer.start();
		}
	}

	public void stop() {
		if (timer != null) {
			timer.stop();
			timer = null;
		}
	}

	private String padElement(int expr, char padChar) {
		String result = "";
		if (expr < 10) result = result.concat(String.valueOf(padChar));
		result = result.concat(String.valueOf(expr));
 		return(result);
	}

}
