/*
Simple text scroller
Date: March 24th, 1996
Code: Pronto (pronto@forex.ee)
Copyright (c) 1996, Deus Ex Machina
*/

import java.awt.*;

public class Scroller extends java.applet.Applet implements Runnable {
        Thread          timer = null;
        String          scrollerString;
        Image           offScreenImage;
        Graphics        offScreenGraphics;
        Font            scrollerFont;
        FontMetrics     scrollerFontMetrics;
        int             scrollerWidth;
        int             scrollerPosition;

        public void init() {
		scrollerString = getParameter("text");
		if (scrollerString == null)
			scrollerString = new String("This is a sample text ...");
                scrollerFont = new Font("Helvetica", Font.BOLD, 22);
                scrollerFontMetrics = getFontMetrics(scrollerFont);
                scrollerWidth = scrollerFontMetrics.stringWidth(scrollerString);
                scrollerPosition = size().width;
                offScreenImage = createImage(size().width, size().height);
                offScreenGraphics = offScreenImage.getGraphics();
        }

        public void scrollDo() {
                scrollerPosition--;
                if (scrollerPosition < (scrollerWidth * -1))
                        scrollerPosition = size().width;
                repaint();
        }

        public void paintScreen(Graphics g) {
                int     fontBottom = scrollerFontMetrics.getAscent();
                g.setColor(Color.white);
                g.fillRect(0, 0, size().width, size().height);
                g.setFont(scrollerFont);
		g.setColor(Color.darkGray);
                g.drawString(scrollerString, scrollerPosition + 1, fontBottom + 1);
		g.setColor(Color.gray);
		g.drawString(scrollerString, scrollerPosition, fontBottom);
        }

        public void paint(Graphics g) {
                paintScreen(offScreenGraphics);
                g.drawImage(offScreenImage, 0, 0, this);
        }

        public void update(Graphics g) {
                paint(g);
        }

	public void run() {
                while (timer != null) {
                        scrollDo();
                        try  timer.sleep(100);
                        catch (InterruptedException e) {}
                repaint();
                }
        timer = null;
        }

        public void start() {
                if (timer == null) {
                        timer = new Thread(this);
                        timer.start();
                }
        }

        public void strop() {
                if (timer != null) {
                        timer.stop();
                        timer = null;
                }
        }
}
