/*
Simple sinus text scroller
Date: March 25th, 1996
Code: Pronto (pronto@forex.ee)
Copyright (c) 1996, Deus Ex Machina
*/

import java.awt.*;

public class SinusScroller extends java.applet.Applet implements Runnable {
        Thread          timer = null;
        String          scrollerString;
        Image           offScreenImage;
        Graphics        offScreenGraphics;
        Font            scrollerFont;
        FontMetrics     scrollerFontMetrics;
        int             scrollerWidth;
        int             scrollerPosition;
	char		scrollerChars[];
	int 		phase = 0;

        public void init() {
		scrollerString = getParameter("text");
		if (scrollerString == null)
			scrollerString = new String("This is a sample text ...");
		scrollerChars = new char[scrollerString.length()];
		scrollerString.getChars(0, scrollerString.length(), scrollerChars, 0);

		System.out.println("* Simple sinus scroller, March 25th, 1996");
		System.out.println("* Copyright (c) 1996, Deus Ex Machina, Pronto (pronto@forex.ee)");
		System.out.println("* All rights reserved");
		
                scrollerFont = new Font("Courier", Font.BOLD, 30);
                scrollerFontMetrics = getFontMetrics(scrollerFont);
                scrollerWidth = scrollerString.length() * 18;
                scrollerPosition = size().width;
                offScreenImage = createImage(size().width, size().height);
                offScreenGraphics = offScreenImage.getGraphics();
        }

        public void scrollDo() {
                scrollerPosition -= 2;
                if (scrollerPosition < (scrollerWidth * -1)) {
                        scrollerPosition = size().width;
			phase = 0;
		}
                repaint();
        }

        public void paintScreen(Graphics g) {
                int     fontBottom = scrollerFontMetrics.getAscent();
		int	counter, x, y;
                g.setColor(Color.white);
                g.fillRect(0, 0, size().width, size().height);
                g.setFont(scrollerFont);
		for (counter = 0; counter < scrollerString.length(); counter++) {
			x = counter * 18;
			y = (int)(Math.sin((counter + phase) * 0.2) * ((size().height - scrollerFontMetrics.getHeight()) / 2)) + ((size().height - scrollerFontMetrics.getHeight()) / 2);
			g.setColor(Color.darkGray);
                	g.drawChars(scrollerChars, counter, 1, scrollerPosition + 1 + x, fontBottom + 1 + y);
			g.setColor(Color.gray);
			g.drawChars(scrollerChars, counter, 1, scrollerPosition + x, fontBottom + y);
		}
		phase++;
        }

        public void paint(Graphics g) {
                paintScreen(offScreenGraphics);
                g.drawImage(offScreenImage, 0, 0, this);
        }

        public void update(Graphics g) {
                paint(g);
        }

	public void run() {
		long	tm = System.currentTimeMillis();
                while (timer != null) {
                        scrollDo();
                        try  {
				tm += 100;
				timer.sleep(Math.max(0, tm - System.currentTimeMillis()));
			}
                        catch (InterruptedException e) {}
                repaint();
                }
        timer = null;
        }

        public void start() {
                if (timer == null) {
                        timer = new Thread(this);
                        timer.start();
                }
        }

        public void stop() {
                if (timer != null) {
                        timer.stop();
                        timer = null;
                }
        }
}
