PROGRAM Cluster;
{
	Analizer of Disk Usage and prognosis for any Cluster size.
	Borland Pascal 7.0

	Remark for users.
	Dear users and hackers!
	You may freely modify this program, use any pieces of source
	in yours program, and if possible please reference my source
	Please do not delete Copyright if you modified source, simply
	add yours self.

	Kindest regards Anatoly Podgoretsky
	Johvi, Estonia
}
USES
	Dos;
TYPE
	tScanProc	=	PROCEDURE(FileNamePath:PathStr);
	pScanProc	=	^tScanProc;
	tFileName	=	STRING[11];
	tDir			=	STRING[80];
CONST
	NoErrors		=	0;
	msgCopyright=	'Disk Usage Utility, Copyright (c) 1996 by NPS';
{$DEFINE English}			{ Mask if you need locale version }
{$IFDEF English}			{ English text constant }
	msgSyntax	=	'Sintax: Cluster [Disk:][Path]';
	msgStartDir	=	'Start directory : ';
	msgClstSize	=	'Cluster size    : ';
	msgFiles		=	'Files           : ';
	msgDirs		=	'  Directories: ';
	msgResult	=	'******   Scan results   ******';
	msgDiskUsed	=	'In fact used : ';
	msgDiskNeed	=	'Really need  : ';
	msgDiskLost	=	'Bytes lost   : ';
	msgWhatIf	=	'What if cluster will be';
	msgLine		=	'--------------------------------';
	msgHeader	=	'Cluster   Bytes lost   Efficient';
{$ELSE}					{ Locale text constant }
	msgSyntax	=	'맮: Cluster [:][]';
	msgStartDir	=	'⮢ ⠫ : ';
	msgClstSize	=	'    : ';
	msgFiles		=	'            : ';
	msgDirs		=	'  ⠫: ';
	msgResult	=	'******    ᪠஢   ******';
	msgDiskNeed	=	'ॡ  䠩 : ';
	msgDiskUsed	=	'ᯮ짮 ࠧ : ';
	msgDiskLost	=	'           : ';
	msgWhatIf	=	' 㤥 ᫨ ࠧ ';
	msgLine		=	'----------------------------';
	msgHeader	=	'       %';
{$ENDIF}
VAR
	ClusterSize	:	LONGINT;
	DSize			:	LONGINT;
	ErNum			:	INTEGER;
	FileSize		:	LONGINT;
	StartupDir	:	DirStr;
	TmpStr		:	STRING;

	actual		:	INTEGER;
	byte_file	:	FILE;
	WorkDir		:	DirStr;
CONST
	Disk			:	BYTE		=	3;
	TotalBytes	:	LONGINT	=	0;
	TotalFiles	:	LONGINT	=	0;
	TotalDirs	:	LONGINT	=	0;
	Overhang		:	ARRAY[1..8] OF LONGINT = (0,0,0,0,0,0,0,0);
	RO_flag		:	BOOLEAN	=	false;

FUNCTION GetClusterSize : LONGINT; ASSEMBLER;
ASM
	MOV	AH,36H
	MOV	DL,0
	INT	21H
	MOV	DX,0
	CMP	AX,0FFFFH
	JNZ	@1
	XOR	AX,AX
	JMP	@exit
@1:
	MUL	CX
@exit:
END;
{
	Scan current directory and all subdirectory
	CallBackFnc		-	Notify procedure; Receive Filename
	FileNamePath	-	Files Template
	FileAttr			-	Files Atributes
}
PROCEDURE ScanDir(CallBackFnc:tScanProc; FileNamePath:PathStr; FileAttr:WORD);
VAR
	CurDir		:	DirStr;
	FileSrcRec	:	SearchRec;
	DirSrcRec	:	SearchRec;
	ErNum			:	INTEGER;
	Index			:	INTEGER;
	Cluster		:	LONGINT;
	Over			:	LONGINT;
BEGIN
	FileAttr := FileAttr AND $27;			{ ReadOnly,Hidden,SysFile,Archive }
	WITH FileSrcRec DO BEGIN				{ Scan all files in directory }
		FindFirst(FileNamePath,FileAttr,FileSrcRec);
		WHILE DosError = NoErrors DO BEGIN
			INC(TotalFiles);
			TotalBytes	:=	TotalBytes	+	Size;
			Cluster	:=	512;
			FOR Index := 1 TO 8 DO BEGIN
				Over	:=	Size MOD Cluster;
				IF Over <> 0 THEN Overhang[Index] := Overhang[Index] + Cluster - Over;
				Cluster	:=	Cluster * 2;
			END;
			CallBackFnc(fExpand(Name));	{ Do User Func }
			FindNext(FileSrcRec);			{ Next File }
		END; { WHILE }
	END; { WITH }
	WITH DirSrcRec DO BEGIN					{ Scan all subdirectory }
		FindFirst('*.*',directory,DirSrcRec);
		WHILE DosError = 0 {NoErrors} DO BEGIN
			IF (Attr = DIRECTORY) AND (NAME[1] <> '.') THEN BEGIN
				INC(TotalDirs);
				GetDir(0,CurDir);
				ChDir(Name);
				ErNum := IoResult;
				IF ErNum = NoErrors THEN BEGIN
					ScanDir(CallBackFnc,FileNamePath,FileAttr);	{ Recursive call }
				END; { IF }
				ChDir(CurDir);
			END{IF};
			FindNext(DirSrcRec);
		END{WHILE};
	END{WITH};
END;	{ ScanDir }

PROCEDURE CallBack(FileNamePath:PathStr); FAR;
BEGIN
	WRITE(#13,msgFiles,TotalFiles,msgDirs,TotalDirs);
END;

FUNCTION Percent(Value,Nominal:LONGINT) : REAL;
BEGIN
	Percent := Value / Nominal * 100;
END;

PROCEDURE PrintResult;
VAR
	Index			:	INTEGER;
	Cluster		:	LONGINT;
	UsedBytes	:	LONGINT;
	lDiskSize	:	LONGINT;
BEGIN
	WriteLn;
	WriteLn;
	WriteLn(msgResult);
	lDiskSize	:=	DiskSize(0);
	Cluster		:=	512;
	FOR Index := 1 TO 8 DO BEGIN
		IF Cluster = ClusterSize THEN BEGIN
			UsedBytes := TotalBytes + Overhang[Index];
		END;
		Cluster := Cluster * 2;
	END;
	WRITELN(msgDiskUsed,UsedBytes:10,'100 %':9);
	WRITELN(msgDiskNeed,TotalBytes:10,Percent(TotalBytes,UsedBytes):7:1,' %');
	WRITELN(msgDiskLost,UsedBytes - TotalBytes:10,Percent(UsedBytes - TotalBytes,UsedBytes):7:1,' %');
	Cluster	:=	512;
	WriteLn;
	WriteLn(msgWhatIf);
	WRITELN(msgLine);
	WRITELN(msgHeader);
	FOR Index := 1 TO 8 DO BEGIN
		WRITE(Cluster:7);
		WRITE(Overhang[Index]:13);
		IF TotalBytes > 0 THEN BEGIN
			WRITELN(TotalBytes / (TotalBytes + Overhang[Index]) * 100:7:1)
		END;
		Cluster := Cluster * 2;
	END;
	WRITELN(msgLine);
END;	{ PrintResult }

BEGIN
	WriteLn;
	WriteLN(msgCopyright);
	GetDir(0,StartupDir);													{ Save Startup directory }
	IF ParamCount > 0 THEN BEGIN											{ Setup }
		IF (WorkDir[1]	=	'/') AND (WorkDir[2] = '?') THEN BEGIN	{ Check for help }
			WriteLN(msgSyntax);
			HALT;
		END;
		WorkDir	:= ParamStr(1); END
	ELSE BEGIN
		WorkDir	:=	'.';														{ Current and low }
	END{IF};
	ChDir(WorkDir);
	IF ioResult = NoErrors THEN BEGIN
		ClusterSize	:=	GetClusterSize;
		WriteLn;
		WriteLn(msgStartDir,WorkDir);
		WriteLn(msgClstSize,ClusterSize);
		ScanDir(CallBack,'*.*',AnyFile);
		PrintResult;
	END;
	ChDir(StartupDir);
END.