program starwars_scroller;
{
  STARWARS-SCROLLER
  - by Bjarke Vikse
  feb 1994

  THIS PROGRAM WAS CODED BY BJARKE VIKS0E.
  YOU ARE FREE TO DO WHATEVER YOU WANT WITH THIS PIECE OF CODE.
  E-MAIL ME AT: dat92230@rix02.lyngbyes.dk IN 1994 FOR CHAT AND CODE.

  Needs ilbm-font called 'font.lbm' in current path.
  Font by SLIDE, ol' buggar.

  This is a simple horizontal scaled line engine.
}

(*{$DEFINE DEBUG}*)

uses
	DEMOINIT, TWEAK1;

const
	LINES = 100;					{pixel-lines of starwars-text}
	ABUFSIZE = 5500;				{pre-calc buffer-size}

	MAXSTRINGS = 5;				{lines of scroll-text}
	MAXTEXTSIZE = WIDTH*190;	{size of textbuffer-plane}


type
	addbufptr = ^addbuftype;
	addbuftype = array[0..ABUFSIZE] of word;
	addptrptr = ^addptrtype;
	addptrtype = array[0..lines] of pointer;
	addsizeptr = ^addsizetype;
	addsizetype = array[0..lines] of word;
	xposptr = ^xpostype;
	xpostype = array[0..lines] of word;

	scrollstring = string[14];

var
	font : pScreen;
	buffer : pScreen;

	addbuffer1 : addbufptr;
	addptrs1 : addptrtype;
	addsize1 : addsizetype;
	xpos1 : xpostype;

	addbuffer2 : addbufptr;
	addptrs2 : addptrtype;
	addsize2 : addsizetype;
	xpos2 : xpostype;

	addbuffer3 : addbufptr;
	addptrs3 : addptrtype;
	addsize3 : addsizetype;
	xpos3 : xpostype;

	addbuffer4 : addbufptr;
	addptrs4 : addptrtype;
	addsize4 : addsizetype;
	xpos4 : xpostype;

	scrolloffset : word;
	textpos : integer;
	textypos : integer;

const
	display1 : integer = $0000;
	display2 : integer = $4000;

	persp : array[0..lines] of word =
	(2,1,2,2,1,1,2,2,1,1,2,2,1,1,1,2,1,1,1,1,1,2,1,1,1,1,2,1,
	1,1,1,1,1,1,1,1,1,0,1,1,1,0,1,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,0,
	1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,
	0,0,0,1,0,0,0,0,0,1,0,0,0);

	scrolltext : array[1..MAXSTRINGS] of scrollstring =
	('             ',
	 ' DETTE ER EN ',
	 '  STARWARS-  ',
	 ' SCROLLER!!! ',
	 '             ');



(*------------------------------------------------*)

procedure CalcAddBuffer;
{
 Precalc arrays. Actually a simple horizontal-scaling is done here!
 Uses float-points calculations which take up quite a few milliseconds
 if you don't have an co-processor ;-) ...
}
const
	scrsize = 80*200;
var
	x1,x2 : real;
	a1,a2,dela : real;
	x : word;
	i,j : integer;
	index1,size1 : word;
	index2,size2 : word;
	index3,size3 : word;
	index4,size4 : word;
begin
	fillchar(addbuffer1^,ABUFSIZE,0);
	fillchar(addbuffer2^,ABUFSIZE,0);
	fillchar(addbuffer3^,ABUFSIZE,0);
	fillchar(addbuffer4^,ABUFSIZE,0);

	index1:=0; index2:=0; index3:=0; index4:=0;

	x1:=104.0;
	x2:=215.0;
	for i:=0 to lines do begin
		addptrs1[i]:=@addbuffer1^[index1];
		addptrs2[i]:=@addbuffer2^[index2];
		addptrs3[i]:=@addbuffer3^[index3];
		addptrs4[i]:=@addbuffer4^[index4];
		size1:=0; size2:=0; size3:=0; size4:=0;

		a1:=0.0; a2:=319.0;
		dela := 319.0/(x2-x1);

		for j:=round(x1) to round(x2) do begin
			x:=round(a1);
			case (j and 3) of
				0 : begin
					if (size1=0) then xpos1[i]:=j shr 2;
					addbuffer1^[index1]:=(x shr 2)+((x and 3)*scrsize);
					inc(index1); inc(size1);
					 end;
				1 : begin
					if (size2=0) then xpos2[i]:=j shr 2;
					addbuffer2^[index2]:=(x shr 2)+((x and 3)*scrsize);
					inc(index2); inc(size2);
					 end;
				2 : begin
					if (size3=0) then xpos3[i]:=j shr 2;
					addbuffer3^[index3]:=(x shr 2)+((x and 3)*scrsize);
					inc(index3); inc(size3);
					 end;
				3 : begin
					if (size4=0) then xpos4[i]:=j shr 2;
					addbuffer4^[index4]:=(x shr 2)+((x and 3)*scrsize);
					inc(index4); inc(size4);
					 end;
			end;
			a1:=a1+dela;
		end;
		addsize1[i]:=size1;
		addsize2[i]:=size2;
		addsize3[i]:=size3;
		addsize4[i]:=size4;
		x1:=x1-1.0;
		x2:=x2+1.0;
	end;
end;

procedure SetScrollText;
const
	alfabet : string = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!.?:-()*,`/ ';
var
	ch : char;
	nr : integer;
	i,j,k : integer;
begin
	for i:=1 to MAXSTRINGS do
		for j:=1 to length(scrolltext[i]) do begin
			nr:=1;
			ch:=scrolltext[i,j];
			for k:=1 to length(alfabet) do if (ch=alfabet[k]) then nr:=k;
			scrolltext[i,j]:=chr(nr-1);
		end;
end;

procedure SetColors;
var
	i,j : integer;
	c : integer;
	a,b : real;
begin
	a:=1.0;
	for i:=0 to 31 do begin
		c:=1;
		for j:=0 to 7 do begin
			SetRGB((i*8)+j,round(CMAP[c]*a),round(CMAP[c+1]*a),round(CMAP[c+2]*a));
			inc(c,3);
		end;
		a:=a-(1.0/32.0);
	end;
end;

procedure InitDemo;
var
	i : word;
begin
	Screen_Off;
	ClearWholeScreen;

	New(font);
	New(buffer);
	New(addbuffer1); New(addbuffer2); New(addbuffer3); New(addbuffer4);
	LoadPix(font,'FONT.LBM');

	CalcAddBuffer;
	SetScrollText;
	SetColors;

	fillchar(buffer^,SCRSIZE,0);
	for i:=0 to lines do persp[i]:=persp[i]*WIDTH;
	scrolloffset:=0;
	textpos:=1; textypos:=0;
	Screen_on;
end;

procedure UninitDemo;
var
	i : word;
begin
	Dispose(addbuffer1); Dispose(addbuffer2); Dispose(addbuffer3); Dispose(addbuffer4);
	Dispose(buffer);
	Dispose(font);
end;


(*------------------------------------------------*)

procedure SwapDisplay;
var
	temp : word;
begin
	temp:=display1;
	display1:=display2;
	display2:=temp;
	SetAddress(Ptr(SEGA000,display2));
end;


(*------------------------------------------------*)

procedure StarWars(addptrs : addptrptr; addsize : addsizeptr; xpos : xposptr);
{print scroll. Actually get offsets from pre-calc'ed arrays and
 insert color-pixels in a line. Moves a word to speed up things.}
var
	i,colcount : integer;
	col : byte;
	scroffset, scry : word;
	scrollpos : word;
	bptr : pointer;
	size : word;
begin
	scry := WIDTH*90;
	scrollpos:=scrolloffset;
	colcount:=0;
	col:=$F8;

	for i:=0 to lines do begin
		bptr := addptrs^[i];
		scroffset:= xpos^[i]+scry;
		size := addsize^[i];
		inc(scrollpos,persp[i]);
		if (scrollpos >= MAXTEXTSIZE) then dec(scrollpos,MAXTEXTSIZE);
		asm
			push	bp
			mov	es,SEGA000
			mov	di,display1
			add	di,scroffset
			mov	ax,WORD PTR buffer+2
			{mov	fs,ax} DB $8E,$E0
			mov	bx,WORD PTR buffer
			add	bx,scrollpos
			mov	cx,size
			mov	dl,col
			lds	si,bptr
			cld

			test	di,1				{dest. address on even address?}
			jz		@oneven
			lodsw						{get offset}
			add	ax,bx
			mov	bp,ax
			DB FS; mov	al,[bp]	{get pixel}
			add	al,dl				{add color factor}
			stosb
			dec	cx
			jcxz	@done
@oneven:
			shr	cx,1
@xloop:	lodsw						{get offset}
			add	ax,bx
			mov	bp,ax
			DB FS; mov	dh,[bp]	{get actual pixel}
			add	dh,dl				{add color factor}
			lodsw						{get another offset}
			add	ax,bx
			mov	bp,ax
			DB FS; mov	ah,[bp]	{get that pixel}
			add	ah,dl				{add color factor}
			mov	al,dh
			stosw						{store both pixels}
			dec	cx
			jnz	@xloop
@done:
			mov	ax,SEG @DATA
			mov	ds,ax
			pop	bp
		end;
		inc(scry,WIDTH);
		inc(scrollpos,WIDTH);
		if (scrollpos = MAXTEXTSIZE) then scrollpos:=0;
		inc(colcount); if (colcount=4) then begin colcount:=0; dec(col,8); end;
	end;
end;


(*------------------------------------------------*)

procedure DoText;
{copy one line from each char to the buffer.
 Notice that we use mirror-buffer so no scrolling is needed}
var
	i : integer;
	plotoffset : word;
	yoff,stroff : word;
	textantal : integer;
begin
	inc(scrolloffset,WIDTH);
	if (scrolloffset = MAXTEXTSIZE) then scrolloffset:=0;
	plotoffset:=scrolloffset+(185*WIDTH);
	if (plotoffset >= MAXTEXTSIZE) then dec(plotoffset,MAXTEXTSIZE);

	inc(textypos);
	if (textypos = 32) then begin
		textypos:=0;
		inc(textpos); if (textpos > MAXSTRINGS) then textpos:=1;
	end;
	yoff := textypos*WIDTH;
	stroff := (textpos-1)*SIZEOF(scrollstring);

	asm
		mov	textantal,1
@loop:
		lea	si,scrolltext
		add	si,stroff
		add	si,textantal
		xor	ah,ah
		mov	al,[si]
		cwd
		mov	cx,10
		div	cx
		mov	bx,dx
		cwd
		mov	cx,80*32
		mul	cx
		shl	bx,3
		add	ax,bx

		push	ds
		les	di,buffer
		add	di,plotoffset
		lds	si,font
		add	si,yoff
		add	si,ax
		cld
		mov	bx,(80*200)-6
		DB LONG; movsw
		movsw
		add	si,bx
		add	di,bx
		DB LONG; movsw
		movsw
		add	si,bx
		add	di,bx
		DB LONG; movsw
		movsw
		add	si,bx
		add	di,bx
		DB LONG; movsw
		movsw
		pop	ds

		add	plotoffset,6	{space (in bytes) between two chars}
		inc	textantal
		cmp	textantal,(TYPE scrollstring)-1
		jne	@loop
	end;
end;


(*------------------------------------------------*)

procedure RunOnce;
begin
	SwapDisplay;
	VBLANK;
{$IFDEF DEBUG}
	setRGB(0,63,0,0);
{$ENDIF}
	SetBitplanes(1);
	StarWars(@addptrs1,@addsize1,@xpos1);
	SetBitplanes(2);
	StarWars(@addptrs2,@addsize2,@xpos2);
	SetBitplanes(4);
	StarWars(@addptrs3,@addsize3,@xpos3);
	SetBitplanes(8);
	StarWars(@addptrs4,@addsize4,@xpos4);
	DoText;
{$IFDEF DEBUG}
	setRGB(0,0,0,0);
{$ENDIF}
end;


begin
	OpenScreen;
	InitDemo;
	SetAllInterrupts;
	repeat RunOnce until Key='e';
	RestoreAllInterrupts;
	UninitDemo;
	CloseScreen;
end.
