program forward_stars;
uses dos,crt,krush2;

type dotpos = record
                x,y    : word; { X and Y coordinate }
                c,sp,os: byte; { color, speed       }
                r      : real; { radius             }
                ang    : real; { angle              }
                srad   : real; { another radius     }
              end;


const maxdots  = 300;
      cx       = 160;
      cy       = 95;

var add          : real;
    scan         : byte;
    i,ox,oy      : word;
    dot          : array[0..maxdots] of dotpos;

procedure checkscancode;
begin
  asm
    mov  ax,0h      { Int 16 -> Read keyboard }
    int  16h
    mov  scan,ah
  end;
  if (scan=$50) and (add>-50)  then add:=add-0.1; { Down Arrow  }
  if (scan=$48) and (add<50) then add:=add+0.1; { Up Arrow    }
end;


procedure setupdots;
begin
  randomize;
  for i:=1 to 64 do setcolor(i,i,i,i);{(i,5,5,i);}
  setcolor(65,63,0,5);
  for i:=0 to maxdots do begin
    dot[i].ang := random(360);
    dot[i].c   := random(63);
    dot[i].r   := random(206);
    dot[i].sp  := random(3);
    dot[i].os  := dot[i].sp;
    dot[i].srad:= random(80);
  end;
end;

procedure move_dots;
begin
  repeat
    for i:=0 to maxdots do begin  { Repeat for all the stars }

    if (dot[i].sp>0) then dec(dot[i].sp) else begin
      if (dot[i].r<dot[i].srad) then dot[i].r:=189;

      if (dot[i].x>2) and(dot[i].x<318) and (dot[i].y>2) and (dot[i].y<198)
      then putpixel(dot[i].X,dot[i].Y,0);                   { Erase old.  }

      dot[i].X := cx+round(dot[i].r * sin(dot[i].ang));      { Set new     }
      dot[i].Y := cy+round(dot[i].r * cos(dot[i].ang));      { coordinates }

      if (dot[i].x>2) and (dot[i].x<318) and (dot[i].y>2) and (dot[i].y<198)
      then putpixel(dot[i].x,dot[i].y,dot[i].c);             { New Star    }

      if (dot[i].x>319) and (add>0) or (dot[i].x<1) and (add>0)
      or (dot[i].y<1) and (add>0) or (dot[i].y>199) and (add>0)
      then dot[i].r:=dot[i].srad+10;{8+random(50);}

      dot[i].r  := dot[i].r+add;                       { Increase radius }
      dot[i].sp := dot[i].os;
    end;
  end;
  if keypressed then checkscancode;
  until port[$60]=1;
end;

begin
  Screenmode($13); cls(0); add:=3;
  Setupdots; {for i:=0 to 319 do mem[$A000:56320+i] := 63;}
  Move_dots;
end.
