; *****************************************************************************
;
;           MTASK.ASM ... General-purpose multitasker interface code
;                        Release 2.01  (March 30, 1991)
;
;                       Copyright (C) 1991, David Begley
;
;                           Authors: David Begley
;                                    Anthony Rumble
;
; *****************************************************************************

;                *********************************************
;                      Turbo Assembler 2.01 - IDEAL Mode
;                Conditionally assembles for Pascal, C and C++
;                *********************************************

; NOTES:
;
;   To assemble for C/C++, define the symbol "CEE".  This will create all the
;   necessary code for linking into Turbo C/C++.  If CEE is not defined,
;   Turbo Pascal is assumed.
;
;   If CEE is defined, a second symbol, "MEMORY" must be defined, as per the
;   required memory model:
;
;          - tiny
;          - small
;          - medium
;          - compact
;          - large
;          - huge
;
;   Case is insensitive.  If MEMORY is not defined, the small memory model is
;   assumed.

; Values returned by DetectMultitasker correspond to:
;   0  no known multitasker found, DOS Idle interrupt assumed
;   1  generic TopView detected
;   2  generic TAME=controlled detected
;   3  DESQview
;   4  MultiDOS II
;   5  MultiDOS III
;   6  DoubleDOS
;   7  Windows 2.xx or lower
;   8  Windows 3.xx
;   9  OS/2's DOS Compatability Box
;; 10  ConcurrentDOS
;  11  PC-MOS/386
;  12  MultiLink
;
; Planned multitasker support:
;   VM/386
;   VMiX
;   CSwitch
;
; Possible enhancements:
;   C++ inline macros?
;   Turbo Pascal 6.0 inline assembly version?
;   Assembly compatible routine (perhaps try the C/C++ one?)
;   Virtual screen detection
;   Processor specific operations (ie., 286, 386 and 486 commands)
;   Fix the MultiDOS III detection code with the new API calls
;   Fix the ConcurrentDOS detection problem

; Pascal definitions:
;   function DetectMultitasker : byte;
;   procedure TaskSwitch;

; C/C++ definitions:
;   unsigned char DetectMultitasker();
;   void TaskSwitch();


                   IDEAL                  ; TASM's "IDEAL" assembly mode
                   INCLUDE "SM86TI.INC"   ; Use SM86 macro package

                   %TITLE "MTASK OFFICIAL RELEASE 2.01"
                   %SUBTTL "Using Joe Moldovan's SM86 v1.10"

                   _sm86 LIST             ; Begin SM86 code


                   IFDEF CEE
                     DOSSEG               ; Use DOS segment ordering
                     IFNDEF MEMORY
                       MODEL small        ; Small memory model is default
                     ELSE
                       MODEL MEMORY       ; Use memory model programmer wants
                     ENDIF
                     PUBLIC C DetectMultitasker, C TaskSwitch
                   ELSE
                     MODEL TPascal        ; Use Turbo Pascal memory model
                     PUBLIC Pascal DetectMultitasker, Pascal TaskSwitch
                   ENDIF


                   MACRO Begin            ; Standard entry code
                     push bp
                     mov bp, sp
                   ENDM

                   MACRO Bend             ; Standard exit code
                         mov sp, bp
                         pop bp
                         IFDEF CEE
                           ret
                         ELSE
                           retf
                         ENDIF
                   ENDM


; Recognition codes
None               =  0                ; No known multitasker
TopView            =  1                ; generic TopView compatible detected
TAME               =  2                ; generic TAME-controlled detected
DESQview           =  3                ; DESQview
MultiDOS2          =  4                ; MultiDOS II
MultiDOS3          =  5                ; MultiDOS III
DoubleDOS          =  6                ; DoubleDOS
Windows2           =  7                ; Windows 2.xx or lower
Windows3           =  8                ; Windows 3.xx
OS2                =  9                ; OS/2's DOS Compatability Box
;ConDOS             = 10                ; ConcurrentDOS
PCMOS              = 11                ; PC-MOS/386
MultiLink          = 12                ; MultiLink


                   CODESEG

WhichOne           DB 0                ; Which multitasker was found
Detected           DB 0                ; Flag: set if DetectMultitasker has run


;; ******************** DetectMultitasker
;;
;; This attempts to detect which (if any) multitasker is currently active or is
;; loaded into the machine on which the host application is running on.
;;
;; As well, as returning the type of multitasker found, a record is kept
;; internally so as to automate the task-switching process.  This means that
;; if the application has no need of knowing what multitasker it is under, it
;; doesn't need to call DetectMultitasker, AT ALL!!  The first call to
;; TaskSwitch will automatically call DetectMultitasking for you.
;;
;; ********************

                   IFDEF CEE
                     PROC DetectMultitasker NEAR
                   ELSE
                     PROC DetectMultitasker FAR
                   ENDIF

                   Begin

                   mov ax, 2B01h                 ; --- Look for DESQview
                   mov cx, 4445h                 ;  |
                   mov dx, 5351h                 ;  |
                   int 21h                       ;  |
                   _if al NE 0FFh                ;  |
                     mov al, DESQview            ;  +- FOUND
                     jmp ExitDetect              ;  |
                   _end                          ;  +- Not detected

                   mov ax, 4680h                 ; --- Look for Windows 3.xx
                   int 2Fh                       ;  |
                   _if ax E 0                    ;  |
                     mov al, Windows3            ;  +- FOUND
                     jmp ExitDetect              ;  |
                   _end                          ;  +- Not detected

                   mov ax, 1600h                 ; --- Look for Windows 2.xx
                   int 2Fh                       ;  |
                   _if al NE 0 and al NE 80h     ;  |
                     mov al, Windows2            ;  +- FOUND
                     jmp short ExitDetect        ;  |
                   _end                          ;  +- Not detected

                   mov ah, 30h                   ; --- Look for OS/2
                   int 21                        ;  |
                   _if al E 0Ah                  ;  |
                     mov al, OS2                 ;  +- FOUND
                     jmp short ExitDetect        ;  |
                   _end                          ;  +- Not detected

;                   mov ah, 30h                   ; --- Look for PC-MOS
;                   int 21                        ;  |
;                   push ax                       ;  |
;                   mov ax, 3000h                 ;  |
;                   mov bx, ax                    ;  |
;                   mov cx, ax                    ;  |
;                   mov dx, ax                    ;  |
;                   int 21h                       ;  |
;                   pop bx                        ;  |
;                   _if ax NE bx                  ;  |
;                     mov al, PCMOS               ;  +- FOUND
;                     jmp short ExitDetect        ;  |
;                   _end                          ;  +- Not detected

;                  mov ax, 4451h                 ; --- Look for Concurrent DOS
;                  int 21                        ;  |
;                  _if CARRY                     ;  |
;                    mov al, ConDOS              ;  +- FOUND
;                    jmp short ExitDetect        ;  |
;                  _end                          ;  +- Not detected

;                  mov ah, 0FFh                  ; --- Look for MultiDOS III
;                  int 14h                       ;  |
;                  _if ax E 564Dh or ax E 4D44h  ;  |
;                    mov al, MultiDOS3           ;  +- FOUND
;                    jmp short ExitDetect        ;  |
;                  _end                          ;  +- Not detected

                   mov ah, 35h                   ; --- Look for MultiDOS II
                   mov al, 9Dh                   ;  |
                   int 21h                       ;  |
                   _if bx NE 0                   ;  |
                     mov al, MultiDOS2           ;  +- FOUND
                     jmp short ExitDetect        ;  |
                   _end                          ;  +- Not detected

                   mov ah, 0E4h                  ; --- Look for DoubleDOS
                   int 21h                       ;  |
                   _if al E 01h or al E 02h      ;  |
                     mov al, DoubleDOS           ;  +- FOUND
                     jmp short ExitDetect        ;  |
                   _end                          ;  +- Not detected

                   sub ax, ax                    ; --- Look for MultiLink
                   mov ds, ax                    ;  |
                   mov ax, [ds:01FEh]            ;  |
                   _if ax NE 0                   ;  |
                     mov al, MultiLink           ;  +- FOUND
                     jmp short ExitDetect        ;  |
                   _end                          ;  +- Not detected

                   mov ax, 1022h                 ; --- Look for TopView etc.
                   xor bx, bx                    ;  |
                   int 15h                       ;  |
                   _if bx NE 0                   ;  |
                     mov al, TopView             ;  +- FOUND
                     jmp short ExitDetect        ;  |
                   _end                          ;  +- Not detected

                   mov ax, 2B01h                 ; --- Look for TAME
                   mov cx, 5441h                 ;  |
                   mov dx, 4D45h                 ;  |
                   int 21h                       ;  |
                   _if al E 02h                  ;  |
                     mov al, TAME                ;  +- FOUND
                     jmp short ExitDetect        ;  |
                   _end                          ;  +- Not detected

                   xor al, al                    ; Multitasker not found

ExitDetect:        mov [WhichOne], al            ; Record the multitasker found
                   mov dl, 01h                   ; Detection has been run
                   mov [Detected], dl            ; Record this in a flag

                   Bend

                   ENDP DetectMultitasker


;; ******************** TaskSwitch
;;
;; This executes appropriate task-switching (or time-slicing) code, depending
;; on which multitasker is currently active.  If DetectMultitasking hasn't
;; been called to determine the mutitasker type, then it is automatically
;; called by TaskSwitch so as to set some internal variables and flags.  This
;; automates and speeds the task-switching process, both for the programmer
;; and for the application at run-time.
;;
;; ********************

                   IFDEF CEE
                     PROC TaskSwitch NEAR
                   ELSE
                     PROC TaskSwitch FAR
                   ENDIF

                   Begin

                   mov al, [Detected]            ; Has detection been run?
                   _if al E 0
                     call DetectMultitasker      ; If not, call it
                   _end

                   mov al, [Detected]            ; Based on the m'tasker found
                   _switch al

                     _case TopView - DESQview    ; TopView (and compats.) and
                       mov ax, 1000h             ; DESQview
                       int 15h
                       _if al E DESQview         ; Additional DESQview only
                         mov ax, 101Ah
                         int 15h
                         mov ax, 1025h
                         int 15h
                       _end
                     _break

                     _case Windows2 - OS2        ; Win2, Win3 and OS/2
                       mov ax, 1680h
                       int 2fh
                     _break

                     _case PCMOS                 ; PC-MOS/386
                       mov ax, 0703h
                       mov bx, 3                 ; Give up three ticks
                       xor cx, cx                ; Clear wait on IRQ mask
                       mov dx, cx                ; Clear ports to wait on
                       int 38h
                     _break

                     _case MultiDOS2             ; MultiDOS II
                       int  9Eh
                     _break

                     _case MultiDOS3             ; MultiDOS III
                       mov ax, 1100h             ; Give back 18 timer ticks
                       mov cx, 0012h
                       int 41h
                     _break

                     _case DoubleDOS             ; DoubleDOS
                       mov ax, 0EE06h            ; Give back 6 x 55ms
                       int 21h
                       int 0F4h                  ; Well, BinkleyTerm has it!
                     _break

                     _case MultiLink             ; MultiLink
                       mov ah, 02h
                       xor al, al
                       int 7Fh
                     _break

                _end

                int 28h                          ; Generate Int 0x28 for TSRs

                Bend

                ENDP TaskSwitch

                ENDS

                _endsm86                         ; Completion of SM86 code

                END
