program MTest;   { Tests the features in MTask                                }

uses
  Crt,           { Standard Turbo Pascal CRT unit                             }
  MTask;         { Appropriate MTask .TPU unit                                }

const
  CR = #13;      { Define the carriage return character                       }
  LF = #10;      { Define the line feed character                             }

var
  foobar : string[2];   { Dummy string used in vaious funcs/procs             }


{ Enhance CRT's delay() procedure by adding timeslicing, and status update    }
procedure Pause( Secs : word );
var
  Loop : word;
begin
  for Loop := 1 to (Secs * 1000) do
    begin
      str( (Loop div 1000), foobar );
      write( foobar, CR );
      TaskSwitch;
      delay(1)
    end
end;   { Pause }

{ Enhance the usual "repeat until keypressed" loop by adding timeslicing      }
procedure Get;
begin
  repeat
    TaskSwitch
  until KeyPressed;
  foobar[1] := readkey
end;   { Get }


{ main }
begin
  DirectVideo := false;
  writeln( 'MTest 2.01', LF );

  write( 'Multitasker detected: ' );
  case DetectMultitasker of
     0 : writeln( 'none' );
     1 : writeln( 'TopView or compatible (TaskView, OmniView, etc.)' );
     2 : writeln( 'TAME (2.10/2.20/2.30) controlled programme' );
     3 : writeln( 'DESQview' );
     4 : writeln( 'MultiDOS II' );
     5 : writeln( 'MultiDOS III' );
     6 : writeln( 'DoubleDOS' );
     7 : writeln( 'Windows 2.xx (or lower?)' );
     8 : writeln( 'Windows 3.xx (or higher?)' );
     9 : writeln( 'OS/2''s DOS Compatibility Box' );
    10 : writeln( 'ConcurrentDOS' );
    11 : writeln( 'PC-MOS/386' );
    12 : writeln( 'MultiLink' );
  else
    writeln( '**internal error**' );
  end;

  write( LF, LF, 'Run timer tests? [Y/N] ... ' );
  Get;
  if upcase(foobar[1]) = 'Y' then
    begin
      writeln( CR, LF, LF, 'This task will now pause for 10 seconds.  It should NOT take' );
      writeln( 'up valuable CPU time, as it continually executes task switches' );
      writeln( 'without loosing it''s own pause time...', LF );
      writeln( 'Press any key to begin!' );
      Get;
      writeln( '     GO...' );
      Pause(10);
      writeln( '     STOP.' );
      writeln( LF, LF, 'This task will now pause for 5 seconds.  It should NOT take' );
      writeln( 'up valuable CPU time, as it continually executes task switches' );
      writeln( 'without loosing it''s own pause time...', LF );
      writeln( 'Press any key to begin!' );
      Get;
      writeln( '     GO...' );
      Pause(5);
      writeln( '     STOP.' );
      writeln( LF, LF, 'This task will now pause for 20 seconds.  It should NOT take' );
      writeln( 'up valuable CPU time, as it continually executes task switches' );
      writeln( 'without loosing it''s own pause time...', LF );
      writeln( 'Press any key to begin!' );
      Get;
      writeln( '     GO...' );
      Pause(20);
      writeln( '     STOP.' )
    end;
  writeln( CR, LF, 'MTest - done.' )
end.   { MTest }

