;; SM86 Structured Macros V1.1
;; Joe Moldovan, Sydney Australia
;; Copyright (c) 1988-91

	.xlist

ifdef	??version
	%noincl
	masm51
	quirks
	nowarn	res
endif

.xcref	??sp,??lb,??sh,??mv,??sc,??st,??il,??lf,??tf,??ty,??tx,??tm,??tn,??fy,??fx,??nf,??uw,??wb
.xcref	.not,.flag1,.flag2,.floop,.flagc,.flagb,.fbot,.tfor,.tif,.twh,.tdo,.tsw,.tbrk,.tcon
.xcref	jnna,jnnae,jnnb,jnnbe,jnnc,jnne,jnng,jnnge,jnnl,jnnle,jnno,jnnp,jnns,jnnz,jnpe,jnpo,jnin,jnnotin,jin,jnotin
.xcref	_emit,_push,_pop,_bug,_nextl,_continue,_break,_jmpc,_scans
.xcref	.sm86,.long,.forc,.for,.break,.continue,.if,.,.else,.while,.do,.loop,.switch,.case,.default,.end,.endsm86

if1

ifdef	??version
	%out	**** Assembling under TASM ****
else
	%out	**** Assembling under MASM ****
endif

.sm86	macro	$1,$2
	.sfcond
	.sall

	??sp	=	0	;; Stack pointer
	??lb	=	0	;; Current label number
	??sh	=	0	;; Temporary stack pointer storage
	??mv	=	0	;; Multiple argument counter for .CASE and .DO
	??sc	=	0	;; Structure construct flag for the "." macro
	??st	=	0	;; Structure type flag for the "." macro
	??il	=	0	;; Label value for the "." macro
	??lf	=	0	;; Long jump flag
	??nf	=	0	;; NOT condition active flag
	??wb	=	0	;; While break label flag
	??ty	=	0	;; Temporary type storage
	??tx	=	0	;; Temporary type storage
	??tm	=	0	;; Temporary value storage
	??tn	=	0	;; Temporary value storage
	??fy	=	0	;; Temporary flag storage
	??fx	=	0	;; Temporary flag storage
	??tf	=	0	;; Temporary flag storage

	??uw	EQU	< >	;; .if unwind macro

	.not	=	1
	.flag1	=	1
	.flag2	=	2
	.floop	=	4
	.flagc	=	8
	.flagb	=	10h
	.fbot	=	.floop or .flagb
	.tfor	=	1
	.tif	=	2
	.twh	=	3
	.tdo	=	4
	.tsw	=	5
	.tbrk	=	6
	.tcon	=	7

jnna	macro	$3
	ja	$3
endm
jnnae	macro	$3
	jae	$3
endm
jnnb	macro	$3
	jb	$3
endm
jnnbe	macro	$3
	jbe	$3
endm
jnnc	macro	$3
	jc	$3
endm
jnne	macro	$3
	je	$3
endm
jnng	macro	$3
	jg	$3
endm
jnnge	macro	$3
	jge	$3
endm
jnnl	macro	$3
	jl	$3
endm
jnnle	macro	$3
	jle	$3
endm
jnno	macro	$3
	jo	$3
endm
jnnp	macro	$3
	jp	$3
endm
jnns	macro	$3
	js	$3
endm
jnnz	macro	$3
	jz	$3
endm
jnpe	macro	$3
	jpo	$3
endm
jnpo	macro	$3
	jpe	$3
endm
jnin	macro	$3
	je	$3
endm
jnnotin	macro	$3
	jne	$3
endm
jin	macro	$3
	jne	$3
endm
jnotin	macro	$3
	je	$3
endm

	ifidn	<$1>,<LIST>
		.xall
	elseifidn	<$1>,<DEBUG>
		.lall
		ifidn	<$2>,<ALL>
			.lfcond
		endif
	endif
endm

_emit	macro	$1,$2,$3
	$1&$2&$3
endm

_push	macro	$1,$2,$3,$4,$5
	ifb	<$5>
		??sp	=	??sp + 1
		_push	$1,$2,$3,<$4>,%??sp
		exitm
	endif
	ifnb	<$4>
		??m&$5	macro	$6
			$4 $6
		endm
	endif
	??d&$5	=	$1
	??f&$5	=	$2 or ($3 shl 8)
endm

_pop	macro	$1,$2,$3,$4,$5
	ifb	<$5>
		_pop	$1,$2,$3,$4,%??sp
		??sp	=	??sp - 1
		exitm
	endif
	ife	$5
		_bug	<Stack underflow at %??lb>
	endif
	$1	=	??d&$5
	$2	=	??f&$5 and 00ffh
	$3	=	??f&$5 shr 8
	ifnb	<$4>
		if	$2 ne $4
			_bug	<Invalid nesting at %??lb>
		endif
	endif
endm

_bug	macro	$1
	%out	sm86 says: $1
endm

_nextl	macro
	??lb	=	??lb + 1
endm

_continue	macro	$1,$2
	if	$2 and .flagc
		??cn&$1&:
	endif
endm

_break	macro	$1,$2
	if	$2 and .flagb
		??if&$1&:
	endif
endm

_jmpc	macro	$1,$2,$3
	ife	??lf
		ife	($3 xor ??nf)
			J&$1	$2
		else
			JN&$1	$2
		endif
	else
		ife	($3 xor ??nf)
			JN&$1	$+5
		else
			J&$1	$+5
		endif
		jmp	$2
	endif
	??nf	=	0
endm

_scans	macro	$1,$2,$3
	ifb	<$3>
		??sh	=	??sp
	else
		if	(??f&$3 shr 8) and .floop
			??f&$3	=	??f&$3 or ($2 shl 8) or (.flagb shl 8)
			$1	=	??d&$3
			exitm
		else
			??sh	=	??sh - 1
			ife	??sh
				_bug	<.break or .continue not in loop at %??lb>
				exitm
			endif
		endif
	endif
	_scans	$1,$2,%??sh
endm

.long	macro	$1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14,$15,$16,$17
	??lf	=	1
	ifdif	<$1>,<.>
		.&$1	<$2>,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>,<$17>
	else
		.	<$2>,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>,<$17>
	endif
	??lf	=	0
endm

.forc	macro	$1,$2,$3
	$1

	_emit	??it%??lb,:
	??tf	=	0

	ifnb	<$2>
		??tf	=	.fbot
	endif

	ifnb	<$3>
		_push	??lb,.tfor,??tf,<$3>
	else
		_push	??lb,.tfor,%(??tf or .flag1)
	endif

	ifb	<$2>
		_nextl
	else
		??st	=	.tfor
		??il	=	??lb
		.	$2
	endif
endm

.for	macro	$1,$2,$3,$4,$5,$6,$7
	??ty	=	0

	ifdif	<$2>,<:=>
		??ty	=	1
	elseifdif	<$4>,<to>
		ifdif	<$4>,<downto>
			??ty	=	1
		endif
	elseifnb	<$6>
		ifdif	<$6>,<by>
			??ty	=	1
		endif
	endif

	if	??ty
		_bug	<Invalid keyword in .for at %??lb>
	endif

	if	((((.type $1) and 10h) ne 0) and (((.type $3) and 04h) ne 0))
		ife	$3
			xor	$1,$1
		else
			mov	$1,$3
		endif
	else
		mov	$1,$3
	endif

	_emit	??it%??lb,:
	cmp	$1,$5

	ifidn	<$4>,<to>
		_jmpc	A,??if%??lb,0
	else
		_jmpc	B,??if%??lb,0
	endif

	ifb	<$6>
		ifidn	<$4>,<to>
			_push	??lb,.tfor,.fbot,<inc	$1>
		else
			_push	??lb,.tfor,.fbot,<dec	$1>
		endif
	elseif	((.type $7) and 04h)
		if	($7 eq 1)
			ifidn	<$4>,<to>
				_push	??lb,.tfor,.fbot,<inc	$1>
			else
				_push	??lb,.tfor,.fbot,<dec	$1>
			endif
		elseifidn	<$4>,<to>
			_push	??lb,.tfor,.fbot,<add	$1,$7>
		else
			_push	??lb,.tfor,.fbot,<sub	$1,$7>
		endif
	elseifidn	<$4>,<to>
		_push	??lb,.tfor,.fbot,<add	$1,$7>
	else
		_push	??lb,.tfor,.fbot,<sub	$1,$7>
	endif

	_nextl
endm

.break	macro	$1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14,$15,$16
	_scans	??il,0

	ifb	<$1>
		ife	??lf
			_emit	<jmp	short ??if%??il>
		else
			_emit	<jmp	??if%??il>
		endif
	else
		??st	=	.tbrk
		.	<$2>,$3,<$4>,$5,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
	endif
endm

.continue	macro	$1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14,$15,$16
	_scans	??il,.flagc
	ifb	<$1>
		ife	??lf
			_emit	<jmp	short ??cn%??il>
		else
			_emit	<jmp	??cn%??il>
		endif
	else
		??st	=	.tcon
		.	<$2>,$3,<$4>,$5,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
	endif
endm

.if	macro	$1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14,$15,$16
	??st	=	.tif
	_push	??lb,.tif,.flagb
	??il	=	??lb
	.	<$1>,$2,<$3>,$4,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
endm

.	macro	$1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14,$15,$16
	ifb	<$1>
		exitm
	endif

	ifidn	<$1>,<}>
%		.	#STATUS,??uw,<$2>,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$1>,<TRUE>
		.	#STATUS,NE,$2,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$1>,<FALSE>
		.	#STATUS,E,$2,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$1>,<NOT>
		??nf	=	1
		.	<$2>,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$1>,<CARRY>
		.	#STATUS,C,$2,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$1>,<NOCARRY>
		.	#STATUS,NC,$2,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$1>,<OVERFLOW>
		.	#STATUS,O,$2,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$1>,<NOVERFLOW>
		.	#STATUS,NO,$2,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$1>,<PARITY>
		.	#STATUS,P,$2,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$1>,<NOPARITY>
		.	#STATUS,NP,$2,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$1>,<NEGATIVE>
		.	#STATUS,S,$2,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$1>,<POSITIVE>
		.	#STATUS,NS,$2,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$2>,<TRUE>
		.	<$1>,NE,0,$3,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$2>,<FALSE>
		.	<$1>,E,0,$3,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$2>,<ON>
		.	<$1>,NE,0,$3,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$2>,<OFF>
		.	<$1>,E,0,$3,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$2>,<NOT>
		.	<$1>,NE,$3,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$2>,<==>
		.	<$1>,E,$3,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$2>,<|=>
		.	<$1>,NE,$3,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$2>,<AND>
		.	<$1>,NE,0,$2,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifidn	<$2>,<OR>
		.	<$1>,NE,0,$2,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
		exitm
	elseifb		<$2>
		.	<$1>,NE,0
		exitm
	endif

	ifdif	<$1>,<#STATUS>
		ifdif	<$2>,<IN>
			ifdif	<$2>,<NOTIN>
				if	((.type $1) and 10h) ne 0
					ifb	<$3>
						or	$1,$1
					elseif ((.type $3) and 04h) ne 0
						ife	$3
							or	$1,$1
						else
							cmp	$1,$3
						endif
					else
						cmp	$1,$3
					endif
				else
					cmp	$1,$3
				endif
			else
				test	$3,$1
			endif
		else
			test	$3,$1
		endif
	else
		ifnb	<$3>
			.	#STATUS,$2,,$3,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
			exitm
		endif
	endif

	ifidn	<$4>,<AND>
		if	(??st eq .tif) or (??st eq .twh) or (??st eq .tdo) or (??st eq .tfor)
			_jmpc	$2,??if%??il,.not
			??wb	=	.flagb
			.	<$5>,$6,<$7>,$8,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
			exitm
		elseif	??st eq .tbrk
			_jmpc	$2,??bk%??lb,.not
			??sc	=	.flag2
			.	<$5>,$6,<$7>,$8,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
			exitm
		elseif	??st eq .tcon
			_jmpc	$2,??co%??lb,.not
			??sc	=	.flag2
		endif
	elseifidn	<$4>,<OR>
		if	(??st eq .tif) or (??st eq .twh) or (??st eq .tdo)
			_jmpc	$2,??it%??il,0
			??sc	=	.flag1
		elseif	??st eq .tbrk
			_jmpc	$2,??if%??il,0
		elseif	??st eq .tcon
			_jmpc	$2,??cn%??il,0
		elseif	??st eq .tfor
			_jmpc	$2,??lp%??lb,0
			??sc	=	.flag1
		endif
	elseifidn	<$4>,<{>
		??uw equ <$2>
		exitm
	else
		if	(??st eq .tif) or (??st eq .twh)
			_jmpc	$2,??if%??il,.not
			if	??sc
				_emit	??it%??il,:
			endif
			_nextl
		elseif	??st eq .tdo
			_jmpc	$2,??it%??il,0
			_break	%??il,%??wb
			??wb	=	0
		elseif	??st eq .tbrk
			_jmpc	$2,??if%??il,0
			if	??sc
				_emit	??bk%??lb,:
			endif
			_nextl
		elseif	??st eq .tcon
			_jmpc	$2,??cn%??il,0
			if	??sc
				_emit	??co%??lb,:
			endif
			_nextl
		elseif	??st eq .tfor
			_jmpc	$2,??if%??lb,.not
			if	??sc eq .flag1
				_emit	??lp%??lb,:
			endif
			_nextl
		endif

		??st	=	0
		??sc	=	0
	endif

	.	<$5>,$6,<$7>,$8,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
endm

.else	macro	 $1
	_pop	??tm,??ty,??fy,.tif
	_push	??tm,??ty,%(.flag1 or .flagb)

	ife	??lf
		_emit	<jmp	short ??ie%??tm>
	else
		_emit	<jmp	??ie%??tm>
	endif

	_emit	??if%??tm,:
endm

.while	macro	$1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14,$15,$16
	if	??sp
		_pop	??il,??ty,??wb
		if ??ty eq .tdo
			_continue	%??il,%??wb
			??st	=	.tdo
			.	<$1>,$2,<$3>,$4,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
			exitm
		endif
		_push	??il,??ty,??wb
	endif

	_emit	??cn%??lb,:

	??st	=	.twh
	??il	=	??lb

	_push	??lb,.twh,.fbot
	ifnb	<$1>
		.	<$1>,$2,<$3>,$4,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
	else
		_nextl
	endif
endm

.do	macro	$1,$2,$3
	ife	??mv
		??fx	=	.floop
		??mv	=	.flag1
	endif

	ifnb	<$1>
		ifidn	<$1>,<SAVE>
			push	cx
			??fx	=	??fx or .flag1
		elseifidn	<$1>,<NZ>
			??fx	=	??fx or .flagb
		else
			mov	cx,$1
		endif

		.do	$2,$3
		exitm
	endif

	if	??fx and .flagb
		_emit	<jcxz	??if%??lb>
	endif

	_push	??lb,.tdo,??fx
	_emit	??it%??lb,:
	_nextl
	??mv	=	0
	endm

.loop	macro	$1
	_pop	??tm,??ty,??fy,.tdo
	_continue	%??tm,%??fy
	_emit	<LOOP&$1	??it%??tm>
	_break	%??tm,%??fy

	if	??fy and .flag1
		pop	cx
	endif
endm

.switch	macro	$1
	if ((.type $1) and 04h)
		_bug <Constant selector in .switch at %??lb>
	endif
	_push	??lb,.tsw,.floop
	_push	??lb,.tsw,0,<cmp	$1,>
endm

.case	macro	$1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14,$15,$16
	ifb	<$1>
		if	??mv gt 1
			_emit	??ct%??lb,:
		endif

		??mv	=	0
		_nextl
		exitm
	endif

	ife	??mv
		_pop	??tm,??ty,??fy,.tsw
		if	??fy and .flag1
			_emit	??cf%??tm,:
		endif
		_push	??lb,.tsw,.flag1
	endif

	??mv	=	??mv + 1
	_emit	??m%??sp,<<$1>>

	ifidn	<$2>,<->
		ifb	<$4>
			_jmpc	L,??cf%??lb,0
			_emit	??m%??sp,<<$3>>
			_jmpc	G,??cf%??lb,0
		else
			_jmpc	L,??cc%((??lb * 10) + ??mv),0
			_emit	??m%??sp,<<$3>>
			_jmpc	L,??ct%??lb,0
			_emit	??cc%((??lb * 10) + ??mv),:
		endif

		.case	<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
	else
		ifnb	<$2>
			_jmpc	E,??ct%??lb,0
		else
			_jmpc	NE,??cf%??lb,0
		endif

		ife ((.type $1) and 04h)
			_bug <Variable .case value at %??lb>
		endif

		.case	<$2>,<$3>,<$4>,<$5>,<$6>,<$7>,<$8>,<$9>,<$10>,<$11>,<$12>,<$13>,<$14>,<$15>,<$16>
	endif
endm

.default	macro
	_pop	??tm,??ty,??fy,.tsw
	if	??fy and .flag1
		_emit	??cf%??tm,:
	endif

	_push	??tm,.tsw,.flag2
endm

.endsm86	macro
	if	??sp
		_bug	<Incomplete nesting at end>
	endif
endm

.end	macro	$1
	_pop	??tm,??ty,??fy

	if	??ty eq .tfor
		_continue	%??tm,%??fy
		ife	??fy and .flag1
			_emit	??m%(??sp + 1)
		endif
		_emit	<jmp	??it%??tm>
	elseif	??ty eq .tsw
		ife	??fy and .flag2
			_emit	??cf%??tm,:
		endif
		_pop	??tm,??ty,??fy,.tsw
	elseif	??ty eq .twh
		_emit	<jmp	??cn%??tm>
	elseif	??ty eq .tif
		if	??fy and .flag1
			_emit	??ie%??tm,:
			exitm
		endif
	endif

	_break	%??tm,%??fy
endm

endif

ifdef	??version
	warn
	%incl
endif

	.list

