//-------------------------------------------------------------------------------------------
// PROJECT:			AVI Player Class
// FILE:			AVITestApp.cpp
// OVERVIEW:		AVI Player in full screen mode with Direct Draw
//					and Direct Sound
//   
// REQUIREMENTS: 	DXAVIPlayer.h
//					DXAVIPLayer.cpp
//					DDScreen.cpp
//					DDSurface.cpp
//					DSound.cpp
//					DXErrors.cpp
//					vfw32.lib
//					winmm.lib
//					DirectX SDK (DX3 or DX5)
//					ddraw.lib
//					dsound.lib
//
// REVISION			1.0
// Last Update:		10.09.97
// AUTHOR:			pat@das-netz.de Germany 08.09.97
//-------------------------------------------------------------------------------------------

#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include "DXAVIPlayer.h"

DXAVIPlayer* AVI;	  // AVI object
BOOL bActive = TRUE;  // Is the program running?

/////////////////////////////////////////////////////////////////////////////////////////////
//										FiniApp
/////////////////////////////////////////////////////////////////////////////////////////////

void FiniApp(void)
{
	AVI->Stop();
	delete AVI;
}

/////////////////////////////////////////////////////////////////////////////////////////////
//										WinProc
/////////////////////////////////////////////////////////////////////////////////////////////

long PASCAL WinProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_ACTIVATEAPP:
			bActive = wParam;
		break;

		case WM_KEYDOWN:
			switch(wParam)
			{
				case VK_ESCAPE:
					PostMessage(hWnd, WM_CLOSE, 0, 0);
				break;
			}
		break;

		case WM_DESTROY:
			FiniApp();
			PostQuitMessage(0);
		break;
	}

	return DefWindowProc(hWnd, message, wParam, lParam);
}

/////////////////////////////////////////////////////////////////////////////////////////////
//										InitApp
/////////////////////////////////////////////////////////////////////////////////////////////

BOOL InitApp(HINSTANCE hInst, int nCmdShow)
{
	HWND hWnd;
	WNDCLASS WndClass;

	WndClass.style = CS_HREDRAW | CS_VREDRAW;
	WndClass.lpfnWndProc = WinProc;
	WndClass.cbClsExtra = 0;
	WndClass.cbWndExtra = 0;
	WndClass.hInstance = hInst;
	WndClass.hIcon = LoadIcon(0, IDI_APPLICATION);
	WndClass.hCursor = LoadCursor(0, IDC_ARROW);
	WndClass.hbrBackground = GetStockObject(BLACK_BRUSH);
	WndClass.lpszMenuName = 0;
	WndClass.lpszClassName = "AVI Test";
	RegisterClass(&WndClass);

	hWnd = CreateWindowEx(
		WS_EX_TOPMOST,
		"AVI Test",
		"AVI Test",
		WS_POPUP,
		0,0,
		GetSystemMetrics(SM_CXSCREEN),
		GetSystemMetrics(SM_CYSCREEN),
		NULL,
		NULL,
		hInst,
		NULL);

	if ( !hWnd ) return FALSE;

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	AVI = new DXAVIPlayer();

	if ( !AVI->Create(hWnd, 640, 480, "TEST.AVI", TRUE, TRUE) )
	{
		MessageBox(hWnd, "AVI Create failed. This demo required a "
				   "file in the same directory named test.avi!",
				   "Error", MB_OK);
		return FALSE;
	}

	AVI->SetDest(100, 100, 380, 540);
	AVI->Start();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////
//										WinMain
/////////////////////////////////////////////////////////////////////////////////////////////

int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow)
{
	MSG msg;

	if ( !InitApp(hInst, nCmdShow) ) return FALSE;

	while( 1 )
	{
		if ( PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE) )
		{
			if ( !GetMessage(&msg, NULL, 0, 0 )) return msg.wParam;
			TranslateMessage(&msg); 
			DispatchMessage(&msg);
		}
		else if ( bActive )
		{
			AVI->Run();
		}
		else WaitMessage();
	}
}
