//--------------------------------------------------------------------------------
// PROJECT:			AVI Player Class
// FILE:			DDScreen.cpp
// SUBSYSTEM:		CLASS DXAVIPlayer
// OVERVIEW:		DirectX screen object class implementation
//   
// REQUIREMENTS: 	DXAVIPlayer.h
//					DXAVIPLayer.cpp
//					DDScreen.cpp
//					DDSurface.cpp
//					DSound.cpp
//					DXErrors.cpp
//					vfw32.lib
//					winmm.lib
//					DirectX SDK (DX3 or DX5)
//					ddraw.lib
//					dsound.lib
//
// REVISION			0.9
// Last Update:		10.09.97
// AUTHOR:			pat@das-netz.de Germany 08.09.97
//--------------------------------------------------------------------------------

#include "DXAVIPlayer.h"

//////////////////////////////////////////////////////////////////////////////////
// DDScreen Constructor
//////////////////////////////////////////////////////////////////////////////////

DDScreen::DDScreen(void)
{
	m_lpDD = NULL;
	m_lpDDSFront = NULL;
	m_lpDDSBack = NULL;
}

//////////////////////////////////////////////////////////////////////////////////
// DDScreen Destructor
//////////////////////////////////////////////////////////////////////////////////

DDScreen::~DDScreen()
{
	if ( m_lpDD ) m_lpDD->RestoreDisplayMode();
	delete m_lpDDSBack;
	delete m_lpDDSFront;
	if ( m_lpDD ) m_lpDD->Release();
}

//////////////////////////////////////////////////////////////////////////////////
// DDScreen CreateFullScreen
//////////////////////////////////////////////////////////////////////////////////

BOOL DDScreen::CreateFullScreen(void *hWnd, DWORD Width, DWORD Height, DWORD BPP)
{
	HRESULT rval;
	DWORD dwFlags;
	DDSURFACEDESC ddsd;
	DDSCAPS ddscaps;

	m_lpDD = NULL;
	m_dwPixelWidth = Width;
	m_dwPixelHeight = Height;
	m_BPP = BPP;
	m_hWnd = hWnd;

	dwFlags = DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN | DDSCL_ALLOWREBOOT | DDSCL_ALLOWMODEX;

	rval = DirectDrawCreate(NULL, &m_lpDD, NULL);
	if ( rval != DD_OK ) DDError(rval, hWnd);

	rval = m_lpDD->SetCooperativeLevel(hWnd, dwFlags);
	if ( rval != DD_OK ) DDError(rval, hWnd);

	rval = m_lpDD->SetDisplayMode(m_dwPixelWidth, m_dwPixelHeight, m_BPP);
	if ( rval != DD_OK ) DDError(rval, hWnd);

	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
												DDSCAPS_FLIP |
												DDSCAPS_COMPLEX;
	ddsd.dwBackBufferCount = 1;

	m_lpDDSFront = new DDSurface;
	m_lpDDSBack = new DDSurface;

	rval = m_lpDD->CreateSurface(&ddsd, &m_lpDDSFront->m_lpDDS, NULL);
	if ( rval != DD_OK ) DDError(rval, hWnd);

	ddscaps.dwCaps = DDSCAPS_BACKBUFFER;

	rval = m_lpDDSFront->m_lpDDS->GetAttachedSurface(&ddscaps, &m_lpDDSBack->m_lpDDS);
	if ( rval != DD_OK ) DDError(rval, hWnd);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// DDScreen Flip - swaps the front and back buffers
//////////////////////////////////////////////////////////////////////////////////

HRESULT DDScreen::Flip(void)
{
	HRESULT rval;

	rval = m_lpDDSFront->m_lpDDS->Flip(NULL, DDFLIP_WAIT);
	if ( rval == DDERR_SURFACELOST ) Restore();
	return rval;
}

//////////////////////////////////////////////////////////////////////////////////
// DDScreen Fill - fills the back buffer with a colour
//////////////////////////////////////////////////////////////////////////////////

void DDScreen::Fill(DWORD FillColor)
{
	DDBLTFX ddBltFx;

	ddBltFx.dwSize = sizeof(DDBLTFX);
	ddBltFx.dwFillColor = FillColor;
	m_lpDDSBack->m_lpDDS->Blt(NULL, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &ddBltFx);
}

//////////////////////////////////////////////////////////////////////////////////
// DDScreen Restore - restores the front buffer if it is lost
//////////////////////////////////////////////////////////////////////////////////

void DDScreen::Restore(void)
{
  if ( m_lpDDSFront->m_lpDDS != NULL && m_lpDDSFront->m_lpDDS->IsLost() != DD_OK )
  {
    m_lpDDSFront->m_lpDDS->Restore();
	}
}
