//------------------------------------------------------------------------------
// PROJECT:			AVI Player Class
// FILE:			DDSurface.cpp
// SUBSYSTEM:		CLASS DXAVIPlayer
// OVERVIEW:		DirectX surface object class implementation
//   
// REQUIREMENTS: 	DXAVIPlayer.h
//					DXAVIPlayer.cpp
//					DDScreen.cpp
//					DDSurface.cpp
//					DSound.cpp
//					DXErrors.cpp
//					vfw32.lib
//					winmm.lib
//					DirectX SDK (DX3 or DX5)
//					ddraw.lib
//					dsound.lib
//
// REVISION			0.9
// Last Update:		10.09.97
// AUTHOR:			pat@das-netz.de Germany 08.09.97
//-------------------------------------------------------------------------------

#include "DXAVIPlayer.h"
#include "math.h"

//////////////////////////////////////////////////////////////////////////////////
// DDSurface Constructor
//////////////////////////////////////////////////////////////////////////////////

DDSurface::DDSurface(void)
{
	m_lpDDS = NULL;
	DestRect.top = 0;
	DestRect.left = 0;
	DestRect.bottom = 0;
	DestRect.right = 0;
}

//////////////////////////////////////////////////////////////////////////////////
// DDSurface Destructor
//////////////////////////////////////////////////////////////////////////////////

DDSurface::~DDSurface()
{
	if( m_lpDDS ) m_lpDDS->Release(); 
}

//////////////////////////////////////////////////////////////////////////////////
// DDSurface SetDest
//////////////////////////////////////////////////////////////////////////////////

void DDSurface::SetDest(int t, int l, int b, int r)
{
	DestRect.top = t;
	DestRect.left = l;
	DestRect.bottom = b;
	DestRect.right = r;
}

//////////////////////////////////////////////////////////////////////////////////
// DDSurface Restore
//////////////////////////////////////////////////////////////////////////////////

void DDSurface::Restore(void)
{
	if ( m_lpDDS != NULL && m_lpDDS->IsLost() != DD_OK )
	{
		m_lpDDS->Restore();
	}
}

//////////////////////////////////////////////////////////////////////////////////
// DDSurface Lock
//////////////////////////////////////////////////////////////////////////////////

HRESULT DDSurface::Lock(void)
{
	ZeroMemory(&m_DDSD, sizeof(m_DDSD));
	m_DDSD.dwSize = sizeof(m_DDSD);
	return m_lpDDS->Lock(NULL, &m_DDSD, DDLOCK_WAIT, NULL);
}

//////////////////////////////////////////////////////////////////////////////////
// DDSurface UnLock
//////////////////////////////////////////////////////////////////////////////////

HRESULT DDSurface::UnLock(void)
{
	return m_lpDDS->Unlock(&m_DDSD);
}
