//------------------------------------------------------------------------------
// PROJECT:			AVI Player Class
// FILE:			DSound.cpp
// SUBSYSTEM:		CLASS DXAVIPlayer
// OVERVIEW:		DirectX sound object class implementation
//   
// REQUIREMENTS: 	DXAVIPlayer.h
//					DXAVIPlayer.cpp
//					DDScreen.cpp
//					DDSurface.cpp
//					DXErrors.cpp
//					vfw32.lib
//					winmm.lib
//					DirectX SDK (DX3 or DX5)
//					ddraw.lib
//					dsound.lib
//
// REVISION			0.9
// Last Update:		10.09.97
// AUTHOR:			pat@das-netz.de Germany 08.09.97
//-------------------------------------------------------------------------------

#include "DXAVIPlayer.h"

//////////////////////////////////////////////////////////////////////////////////
// DSound Constructor
//////////////////////////////////////////////////////////////////////////////////

DSound::DSound(void)
{
	m_lpDS = NULL;
}

//////////////////////////////////////////////////////////////////////////////////
// DSound Destructor
//////////////////////////////////////////////////////////////////////////////////

DSound::~DSound()
{
	if ( m_lpDS ) m_lpDS->Release();
}

//////////////////////////////////////////////////////////////////////////////////
// DSound Create
//////////////////////////////////////////////////////////////////////////////////

BOOL DSound::Create(void *hWnd)
{
	HRESULT rval;

	rval = DirectSoundCreate(NULL, &m_lpDS, NULL);
	if ( rval != DS_OK ) DSError(rval, hWnd);

	rval = m_lpDS->SetCooperativeLevel(hWnd, DSSCL_NORMAL);
	if ( rval != DS_OK ) DSError(rval, hWnd);

	return TRUE;
}
