//--------------------------------------------------------------------------------------
// PROJECT:			AVI Player Class
// FILE:			DXAVIPlayer.h
// OVERVIEW:		AVI player with DirectDraw and
//					Direct Sound in full screen mode
//   
// REQUIREMENTS: 	DXAVIPlayer.cpp
//					DDScreen.cpp
//					DDSurface.cpp
//					DSound.cpp
//					DXErrors.cpp
//					vfw32.lib
//					winmm.lib
//					DirectX SDK (DX3 or DX5)
//					ddraw.lib
//					dsound.lib
//
// REVISION			0.9
// Last Update:		10.09.97
// AUTHOR:			pat@das-netz.de Germany 08.09.97
// THANKS:          danny@jags.co.uk
//--------------------------------------------------------------------------------------

#ifndef _CLASSAVIPLAYER_H
#define _CLASSAVIPLAYER_H

#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <ddraw.h>
#include <dsound.h>
#include <vfw.h>

////////////////////////////////////////////////////////////////////////////////////////
// Globals
////////////////////////////////////////////////////////////////////////////////////////

extern "C"
{
	// DirectX Errors
	extern	void	DDError(HRESULT hErr, void* hWnd);
	extern	void	DSError(HRESULT hErr, void* hWnd);
}

////////////////////////////////////////////////////////////////////////////////////////
// DDSurface Class
////////////////////////////////////////////////////////////////////////////////////////

class DDSurface
{
public:
	DDSurface(void);
	~DDSurface();

	void		SetDest(int t, int l, int b, int r);
	void		Restore(void);
	HRESULT		Lock(void);
	HRESULT		UnLock(void);

public:
	int						m_PixelWidth;
	int						m_PixelHeight;
	RECT					SrcRect;
    RECT					DestRect;
	DDSURFACEDESC			m_DDSD;
	LPDIRECTDRAWSURFACE		m_lpDDS;
};

////////////////////////////////////////////////////////////////////////////////////////
// DDScreen Class
////////////////////////////////////////////////////////////////////////////////////////

class DDScreen
{
public:
	DDScreen(void);
	~DDScreen();

	BOOL		CreateFullScreen(void *hWnd, DWORD Width, DWORD Height, DWORD BPP);
	void		Fill(DWORD FillColor);
	void		Restore(void);
	HRESULT		Flip(void);

	DDSurface*	GetFront(void) { return m_lpDDSFront; }
	DDSurface*	GetBack(void) { return m_lpDDSBack; }

public:
	LPDIRECTDRAW	m_lpDD;
	DDSurface*		m_lpDDSFront;
	DDSurface*		m_lpDDSBack;

	DWORD			m_dwPixelWidth;
	DWORD			m_dwPixelHeight;
	DWORD			m_BPP;
	void*			m_hWnd;
};

////////////////////////////////////////////////////////////////////////////////////////
// DSound Class
////////////////////////////////////////////////////////////////////////////////////////

class DSound
{
public:
	DSound(void);
	~DSound();

	BOOL	Create(void *hWnd);

public:
	LPDIRECTSOUND	m_lpDS;
};

////////////////////////////////////////////////////////////////////////////////////////
// DXAVIPlayer Class
////////////////////////////////////////////////////////////////////////////////////////

class DXAVIPlayer : public DDSurface,
				  	public DSound,
					public DDScreen
{
public:
	DXAVIPlayer(void);
	~DXAVIPlayer();

	BOOL			Create(void *hWnd, DWORD dwScreenWidth, DWORD dwScreenHeight,
						   const char* szFilename, BOOL bSound, BOOL bLoop = FALSE);
	BOOL			Start(void);
	void			Stop(void);
	void			NextFrame(void);
	void			ReadFrame(LONG Frame);
	HRESULT			DrawBuffer(void);
	BOOL			GetSound(void);
	BOOL			Run(void);

	virtual HRESULT Draw(DDSurface* Dest);
	virtual HRESULT DrawFast(int X, int Y, DDSurface* Dest);

	friend  void	CALLBACK GetFrameTimer(UINT, UINT, DWORD AviSurface, DWORD, DWORD);

public:
	BOOL	m_bPlaying;
	BOOL	m_bLoop;
	BOOL	m_bDirectSound;
	LONG	m_Index;
	LONG	m_nFrames;
	DWORD	m_Fps;
	int		m_TimerID;
	int		m_TimeTick;

	CRITICAL_SECTION	m_AccessBuffer;
	PAVISTREAM			m_AviStream;
	AVISTREAMINFO		m_StreamInfo;
	LPBYTE				m_Input;
	LPBYTE				m_Output;
	HIC					m_Decompressor;
	LONG				m_Length;
	LONG				m_LinePitch;
	LPBITMAPINFOHEADER	m_InputFormat;
	LPBITMAPV4HEADER	m_TargetFormat;

	PAVISTREAM			m_AviSound;
	AVISTREAMINFO		m_SoundInfo;
	WAVEFORMATEX*		m_SoundFormat;
	LPDIRECTSOUNDBUFFER m_SoundBuffer;
	DWORD				m_LoadPos;
	DWORD				m_LoadSize;
	int					m_SoundFramesAhead;
};

#endif // _CLASSAVIPLAYER_H