//------------------------------------------------------------------------------
// PROJECT:		CD Player Class
//
// OVERVIEW:	CD player class for Win95 WinNT
//
// FILE:		CDPLAYER.CPP
//
// REVISION:	1.1
//
// AUTHOR:		pat@das-netz.de Germany 16.01.98
//------------------------------------------------------------------------------

#include "stdafx.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#include "cdplayer.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDPlayer::CDPlayer()
{
	// We don't have an open device yet
	m_MCIOpen.wDeviceID = -1;
	m_nNumberOfTracks = 0;
	m_nCurTrack = 0;
}

CDPlayer::~CDPlayer()
{	
	// If we have an open device then we'll be nice and close it.	
	if ( m_MCIOpen.wDeviceID != -1 )
	{
		CDPlayer::Stop();
		mciSendCommand(m_MCIOpen.wDeviceID, MCI_CLOSE, NULL, NULL);
	}
}

short CDPlayer::Read()
{
	int   i;
	short nTrackLength;
	
	m_nNumberOfTracks = 0;
	m_MCIOpen.lpstrDeviceType = (LPCTSTR)MCI_DEVTYPE_CD_AUDIO;

	if ( mciSendCommand(NULL, MCI_OPEN, MCI_OPEN_TYPE|MCI_OPEN_TYPE_ID, (DWORD)(LPVOID)&m_MCIOpen) )
	{
		MessageBox(0, "Couldn't open CD player", "Error", MB_OK|MB_ICONERROR);
	}	
		
	m_MCIStatus.dwItem = MCI_STATUS_NUMBER_OF_TRACKS;

	if ( mciSendCommand(m_MCIOpen.wDeviceID, MCI_STATUS, MCI_STATUS_ITEM|MCI_WAIT, (DWORD)(LPVOID)&m_MCIStatus) )
	{
		MessageBox(0, "Error getting number of tracks", "Error", MB_OK|MB_ICONERROR);
		mciSendCommand(m_MCIOpen.wDeviceID, MCI_CLOSE, NULL, NULL);
		return 0;
	}

	m_nNumberOfTracks = (short)m_MCIStatus.dwReturn;

	if ( m_nNumberOfTracks > MAX_TRACKS )
		m_nNumberOfTracks = MAX_TRACKS;

	m_MCIStatus.dwItem = MCI_STATUS_LENGTH;

	for (i = 0; i < m_nNumberOfTracks; i++)
	{
		m_MCIStatus.dwTrack = i+1;
		mciSendCommand(m_MCIOpen.wDeviceID, MCI_STATUS, MCI_TRACK|MCI_STATUS_ITEM|MCI_WAIT,	(DWORD)(LPVOID)&m_MCIStatus);
		nTrackLength = (short)(MCI_MSF_MINUTE(m_MCIStatus.dwReturn)*60 + MCI_MSF_SECOND(m_MCIStatus.dwReturn));
		m_nTrackLength[i] = nTrackLength;
	}

	mciSendCommand(m_MCIOpen.wDeviceID, MCI_CLOSE, NULL, NULL);
	
	return m_nNumberOfTracks;
}

BOOL CDPlayer::Play(short nTrack)
{
	MCI_SET_PARMS	mciSet;
	MCI_PLAY_PARMS	mciPlay;

	CDPlayer::Read();
	
	m_MCIOpen.lpstrDeviceType = (LPCTSTR)MCI_DEVTYPE_CD_AUDIO;

	if ( mciSendCommand(NULL, MCI_OPEN, MCI_OPEN_TYPE|MCI_OPEN_TYPE_ID, (DWORD)&m_MCIOpen) )
	{
		MessageBox(0, "Couldn't open CD player", "Error", MB_OK|MB_ICONERROR);
		return FALSE;
	}	

	// Set the time format to track/minute/second/frame (TMSF).
    mciSet.dwTimeFormat = MCI_FORMAT_TMSF;

    if ( mciSendCommand(m_MCIOpen.wDeviceID, MCI_SET, MCI_SET_TIME_FORMAT, (DWORD)&mciSet) )
    {
        mciSendCommand(m_MCIOpen.wDeviceID, MCI_CLOSE, NULL, NULL);
        return FALSE;
    }  

	mciPlay.dwCallback = 0;
	mciPlay.dwFrom = MCI_MAKE_TMSF(nTrack, 0, 0, 0);

	if ( mciSendCommand(m_MCIOpen.wDeviceID, MCI_PLAY, MCI_FROM, (DWORD)&mciPlay) )
	{
		MessageBox(0, "Error playing track", "Error", MB_OK|MB_ICONERROR);
		return FALSE;
	}
	
	mciSendCommand(m_MCIOpen.wDeviceID, MCI_CLOSE, NULL, NULL);
	
	m_nCurTrack = nTrack;
	return TRUE;
}

void CDPlayer::Stop()
{
	m_MCIOpen.lpstrDeviceType = (LPCTSTR)MCI_DEVTYPE_CD_AUDIO;

	if ( mciSendCommand(NULL, MCI_OPEN, MCI_OPEN_TYPE|MCI_OPEN_TYPE_ID, (DWORD)&m_MCIOpen) )
	{
		MessageBox(0, "Couldn't open CD player", "Error", MB_OK|MB_ICONERROR);
		return;
	}
	
	mciSendCommand(m_MCIOpen.wDeviceID, MCI_STOP, NULL, NULL);

	mciSendCommand(m_MCIOpen.wDeviceID, MCI_CLOSE, NULL, NULL); 
}

BOOL CDPlayer::Next()
{
	if ( (m_nCurTrack+1) <= m_nNumberOfTracks )
		return CDPlayer::Play((m_nCurTrack+=1));
	else return FALSE;
}

BOOL CDPlayer::Previous()
{
	if ( (m_nCurTrack-1) > 0 )
		return CDPlayer::Play((m_nCurTrack-=1));
	else return FALSE;
}

short CDPlayer::GetTrackLength(short nTrack)
{
	if ( (nTrack>0) && (nTrack<=m_nNumberOfTracks) )
		return m_nTrackLength[nTrack-1];
	else return 0;
}

void CDPlayer::SetTrackLength(short nTrack, short nNewLength)
{
	if ( (nTrack>0) && (nTrack<=m_nNumberOfTracks) )
		m_nTrackLength[nTrack-1] = nNewLength;
}

short CDPlayer::GetTotalLength()
{
	short nTotalLength = 0;
	short nTrack;

	for (nTrack = 0; nTrack < m_nNumberOfTracks; nTrack++)
		nTotalLength = (short) (nTotalLength + m_nTrackLength[nTrack]);

	return nTotalLength;
}
