//------------------------------------------------------------------------------
// PROJECT:		CD Player Class
//
// OVERVIEW:	CD player class for Win95 WinNT
//
// FILE:		CDPLAYER.H
//
// REVISION:	1.1
//
// AUTHOR:		pat@das-netz.de Germany 16.01.98
//------------------------------------------------------------------------------

#if !defined _CDPLAYER_H 
#define      _CDPLAYER_H

#include <mmsystem.h>

#define MAX_TRACKS 100

class CDPlayer
{
	public:

		CDPlayer	(void);
		~CDPlayer	();

		short	Read				(void);

		short	GetNumberOfTracks	(void)			{ return m_nNumberOfTracks; }
		void	SetNumberOfTracks	(short nTracks)	{ m_nNumberOfTracks = nTracks; }

		short	GetTrackLength		(short nTrack);
		void	SetTrackLength		(short nTrack, short nNewLength);
		short	GetTotalLength		(void);

		BOOL	Play				(short nTrack = 1);
		void    Stop				(void);
		BOOL	Next				(void);
		BOOL	Previous			(void);

	private:

		short				m_nCurTrack;
		short				m_nNumberOfTracks;
		short				m_nTrackLength[MAX_TRACKS];

		MCI_STATUS_PARMS	m_MCIStatus;
		MCI_OPEN_PARMS		m_MCIOpen;
};

#endif // _CDPLAYER_H
