//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDX Class Library - CDX.lib ]
// Source File:  [ CDXMusic Implementation ]
// Author:       [ Danny Farley - danny@jags.co.uk ]
// Revision:     [ 1.5 ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDX.h"

//////////////////////////////////////////////////////////////////////////////////
// CDXMusic Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXMusic::CDXMusic(void *hWnd)
{
	m_hWnd = hWnd;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXMusic Play
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXMusic::Play(const char *Filename)
{
	if(Filename == NULL) return FALSE;
	char buffer[256];

	sprintf(buffer, "open %s type sequencer alias MUSIC", Filename);

	if (mciSendString("close all", NULL, 0, NULL) != 0)
	{
		return(FALSE);
	}

	if (mciSendString(buffer, NULL, 0, NULL) != 0)
	{
		return(FALSE);
	}

	if (mciSendString("play MUSIC from 0 notify", NULL, 0, m_hWnd) != 0)
	{
		return(FALSE);
	}

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXMusic Stop
//////////////////////////////////////////////////////////////////////////////////
CDXMusic::Stop()
{
	if (mciSendString("close all", NULL, 0, NULL) != 0)
	{
		return(FALSE);
	}   

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXMusic Pause
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXMusic::Pause(void)
{
	// Pause if we're not already paused
	if (mciSendString("stop MUSIC", NULL, 0, NULL) != 0)
	{
		return(FALSE);
	}

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXMusic Stop
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXMusic::Resume(void)
{
	// Resume midi
	if (mciSendString("play MUSIC notify", NULL, 0, m_hWnd) != 0)
	{
		return(FALSE);
	}

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXMusic Stop
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXMusic::Restart(void)
{
	// Replay midi
	if (mciSendString("play MUSIC from 0 notify", NULL, 0, m_hWnd) != 0)
	{
		return(FALSE);
	}

	return TRUE;
}
