////////////////////////////////////////////////////////////////////////////////////////
// 
//	Project:    class ComAccess
//	File:       comaccess.h
//	Start date:	17.11.1997
//	Update:     13.01.1998
//	Version:    1.1c
//	Author:     Patrick Feuser pat@das-netz.de Germany
//	Copyright  1997. Alle Rechte vorbehalten
//
////////////////////////////////////////////////////////////////////////////////////////

#ifndef _COMACCESS_H_
#define _COMACCESS_H_


#include <windows.h>


class ComAccess 
{
private:

	HANDLE      m_hCom; // Device handle 

	OVERLAPPED  m_ov;   // A structure that contains informations which are
	                    // used in asynchronous input and output operations

	TCHAR       m_lpszErrorMessage[256];

public:

	ComAccess	(VOID);
	ComAccess	(LPCSTR lpszPortNum);

	~ComAccess	()	{ Close(); }

	BOOL	Open	(LPCSTR lpszPortNum = "com1");
	VOID	Close	(VOID);
	
	DWORD	WriteData	(LPCVOID pdata, DWORD len);
	DWORD	ReadData	(LPVOID  pdest, DWORD len);

	LPSTR	GetErrorMessage	(VOID) { return m_lpszErrorMessage; }

protected:

	VOID	ErrorToString	(LPCSTR lpszMessage);
};


#endif // _COMACCESS_H_
