/*
DOSMEM.C
Win16 app -- allocates all DOS memory (conventional memory below 1MB)

While memory is allocated, you can check Windows 95's behavior when
trying to launch programs without any DOS memory.  A typical Win95
error message in this situation is: "A device attached to the system
is not functioning"!

Andrew Schulman
andrew@ora.com
http://www.ora.com/windows/
ftp://ftp.ora.com/pub/examples/windows/win95.update/schulman.html
August 1995
*/

#include <windows.h>

#define MAX_ALLOC   1024
static WORD save[MAX_ALLOC] = {0};

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
    LPSTR lpszCmdLine, int nCmdShow)
{
    char buf[256];
    DWORD dw, bytes;
    int allocs;
    WORD allocsize;
    
    // Allocate all available DOS memory
    for (allocs=bytes=0, allocsize=0xF000;allocsize;)
    {
        if (dw = GlobalDosAlloc(allocsize))
        {
            if (allocs < MAX_ALLOC)
                save[allocs] = LOWORD(dw);
            allocs++;
            bytes += allocsize;
        }
        else allocsize /= 2;    // if alloc failed, try 1/2 size
    }
    
    wsprintf(buf, "Allocated %lu bytes (%luK) DOS memory in %u blocks\n"
                  "Press Ok to free memory, Cancel to leave allocated",
        bytes, bytes / 1024, allocs);
    
    // memory stays allocated until they click okay
    if (MessageBox(0, buf, "DOSALLOC", MB_OKCANCEL) == IDOK)
    {
        int i;
        for (i=0; i<allocs; i++)
            GlobalDosFree(save[i]);
        MessageBox(0, "Freed DOS memory", "DOSALLOC", MB_OK);
    }
    else MessageBox(0, "Leaving allocated DOS memory", "DOSALLOC", MB_OK);
    
    return 0;
}
