/*
DYNLINK32.C
Win32 Console app -- demonstrates Win32 run-time dynamic links to Win16
Via undocumented LoadLibrary16, GetProcAddress16 APIs in KERNEL32

from Schulman, Unauthorized Windows, 1994
NEW: updated to use GetK32ProcAddress

Andrew Schulman
andrew@ora.com
http://www.ora.com/windows/
ftp://ftp.ora.com/pub/examples/windows/win95.update/schulman.html
August 1995

For GetK32ProcAddress, see K32EXP.C and K32EXP.H at:
ftp://ftp.ora.com/pub/examples/windows/win95.update/k32exp.html

Sample output:
LoadLibrary16 @ BFF97E6Eh
GetProcAddress16 @ BFF97A7Eh
LoadLibrary16("kernel") ==> 0x0000012F
GetProcAddress16(0x0000012F, "getprocaddress") ==> 0x011F002C
kernel!getprocaddress at 011F:002C

How ordinal numbers were found:

RUNDLL32.EXE uses LoadLibrary16 and GetProcAddress16, or used to, so
disassemble that to see.  This disassembly from DUMPBIN /DISASM, merged
via AWK program with output from W32DUMP:

  00001101:     push    esi 
  00001102:     mov     BYTE PTR [ebx],00 
  00001105:     inc     ebx 
  00001106:     call    DWORD PTR ds:[LoadLibraryA] 
  0000110c:     mov     DWORD PTR ds:[HMODULE],eax 
  00001111:     test    eax,eax 
  00001113:     jne     loc_FFC011C7 
  00001119:     push    esi 
  0000111a:     call    DWORD PTR ds:[KERNEL32_35] 
  00001120:     mov     DWORD PTR ds:[HMODULE],eax 
  00001125:     cmp     eax,20 
  00001128:     jbe     loc_FFC01182 
  0000112a:     push    ebx 
  0000112b:     push    eax 
  0000112c:     call    DWORD PTR ds:[KERNEL32_37] 
  00001132:     mov     DWORD PTR ds:[PROCADDR],eax 
  00001137:     test    eax,eax 
  00001139:     jne     loc_FFC01161 
  0000113b:     push    ebx 
  0000113c:     push    esi 
  0000113d:     push    00401410 
  00001142:     push    00000400 
  00001147:     push    00 
  00001149:     call    sub_FFC0138D 
  0000114e:     mov     eax,DWORD PTR ds:[HMODULE] 
  00001153:     push    eax 
  00001154:     call    DWORD PTR ds:[KERNEL32_36] 
  0000115a:     xor     eax,eax 
  0000115c:     jmp     loc_FFC0120B 

loc_FFC011C7:
  000011c7:     push    ebx 
  000011c8:     mov     eax,DWORD PTR ds:[HMODULE] 
  000011cd:     push    eax 
  000011ce:     call    DWORD PTR ds:[GetProcAddress] 
  000011d4:     mov     DWORD PTR ds:[PROCADDR],eax 
  000011d9:     test    eax,eax 
  000011db:     jne     loc_FFC0116B 
  000011dd:     push    ebx 
  000011de:     push    esi 
  000011df:     push    00401410 
  000011e4:     push    00000400 
  000011e9:     push    00 
  000011eb:     call    sub_FFC0138D 
  000011f0:     mov     eax,DWORD PTR ds:[HMODULE] 
  000011f5:     push    eax 
  000011f6:     call    DWORD PTR ds:[FreeLibrary] 
  000011fc:     xor     eax,eax 
  000011fe:     jmp     loc_FFC0120B 

Notice that KERNEL32.35 return value is put into same place (here
called HMODULE) as retval from LoadLibraryA, and that KERNEL32.37
retval is put into same place (here called PROCADDR) as return from
GetProcAddress.  FreeLibrary16 is KERNEL32.36.
*/

#define NEW

#include <stdlib.h>
#include <stdio.h>
#define  WIN32_LEAN_AND_MEAN
#include "windows.h"
#ifdef NEW
#include "k32exp.h"
#endif

HINSTANCE (WINAPI *LoadLibrary16)(LPCSTR lpLibFileName);
FARPROC (WINAPI *GetProcAddress16)(HINSTANCE hModule, LPCSTR lpProcName);

void fail(const char *s) { puts(s); exit(1); }

#define GET_PROC(mod, func) GetProcAddress(GetModuleHandle(mod), (func))

main(int argc, char *argv[])
{
    HINSTANCE mod;
    FARPROC fp;
    DWORD arg, retval, dw;
    
    if (argc < 3) 
        fail("usage: dynlnk32 [module name] [function name]");
    
#ifdef NEW
    #define LOADLIBRARY16_ORD       35
    #define GETPROCADDRESS16_ORD    37

    LoadLibrary16 = GetK32ProcAddress(LOADLIBRARY16_ORD);
    GetProcAddress16 = GetK32ProcAddress(GETPROCADDRESS16_ORD);
    printf("LoadLibrary16 @ %08lXh\n", LoadLibrary16);
    printf("GetProcAddress16 @ %08lXh\n", GetProcAddress16);
#else
    #define GET(func, str) \
        if (! (func = GET_PROC("KERNEL32", str))) \
            fail("Cannot link to " str);
        
    GET(LoadLibrary16, "LoadLibrary16");
    GET(GetProcAddress16, "GetProcAddress16");
#endif  
    
    if (! (mod = LoadLibrary16(argv[1])))
        fail("LoadLibrary16 failed");
    printf("LoadLibrary16(\"%s\") ==> 0x%08X\n", argv[1], mod);
    if (! (fp = GetProcAddress16(mod, argv[2])))
        fail("GetProcAddress16 failed");
    printf("GetProcAddress16(0x%08X, \"%s\") ==> 0x%08X\n", 
        mod, argv[2], fp);
	dw = (DWORD) fp;
	printf("%s!%s at %04X:%04X\n", argv[1], argv[2], dw >> 16, dw & 0xFFFF);
    
    return 0;
}

