/////////////////////////////////////////
// File: gcApp.cpp
// Author: Mike J. Norton
//
// pixelDyne copyright 1994,1995,1996
// Developer:  Date:     Comments 
// mjn         962011    game console
///////////////////////////////////////
#define GCAPP_CPP_REV "gcapp.cpp rev 1.02 112296 mjn pixelDyne"

///////////////////////////////////////
// Include Files
///////////////////////////////////////
#include <windows.h>
#include "gcmodes.h"

enum {GT_NONE, GT_INIT, GT_CRITICAL, GT_END};

int  gtState = GT_NONE;

///////////////////////////////////////
// Function Defs
///////////////////////////////////////
LRESULT APIENTRY WndFunc(HWND hwnd, UINT message, WPARAM wParam,LPARAM lParam);
BOOL InitGCApp( HINSTANCE hThisInstance, int nCmdShow );
int  gcScheduler( void );

///////////////////////////////////////
// WinMain
///////////////////////////////////////
int WINAPI WinMain (HINSTANCE hThisInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
{
     MSG msg;
     lpszCmdParam = lpszCmdParam;
     hPrevInstance = hPrevInstance;

     if (!InitGCApp(hThisInstance, nCmdShow))
       return FALSE;
 
     while(1)
     {
       if(PeekMessage(&msg, NULL,0,0,PM_NOREMOVE))
       {
         if(!GetMessage (&msg, NULL, 0, 0))
             return msg.wParam;
         TranslateMessage (&msg);
         DispatchMessage (&msg);        
       }
       else
       {
           // do critical game stuff
		   gcScheduler();
       }
     }
     return msg.wParam;
}

///////////////////////////////////////
// InitGameApp
///////////////////////////////////////
BOOL InitGCApp( HINSTANCE hThisInstance, int nCmdShow )
{
     HWND        hwnd;
     WNDCLASS    wndclass;
     char szAppName[] = "DirectX Game Console Window";

     wndclass.style         = CS_DBLCLKS;
     wndclass.lpfnWndProc   = WndFunc;		 // window function
     wndclass.cbClsExtra    = 0;			 // no extra count of bytes
     wndclass.cbWndExtra    = 0;			 // no extra count of bytes
     wndclass.hInstance     = hThisInstance; // this instance
     wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION);
     wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW);
     wndclass.hbrBackground = GetStockObject (WHITE_BRUSH);
     wndclass.lpszMenuName  = NULL;
     wndclass.lpszClassName = szAppName;

     RegisterClass (&wndclass);

     hwnd = CreateWindowEx (
                    WS_EX_TOPMOST,         // window style
                    szAppName,             // window class name
                    "Generic Windows 95 Game App",// window caption
                    WS_VISIBLE | WS_POPUP | WS_SYSMENU,  // window style
                    CW_USEDEFAULT,         // initial x position
                    CW_USEDEFAULT,         // initial y position
                    640,                   // initial x size
                    480,                   // initial y size
                    NULL,                  // parent window handle
                    NULL,                  // window menu handle
                    hThisInstance,         // program instance handle
                    NULL);                 // creation parameters

     if (!hwnd)
       return FALSE;

     ShowWindow (hwnd, nCmdShow);
     UpdateWindow (hwnd);
     SetFocus(hwnd);
     bIsFullScreen = FALSE; // initialize the game console in window
     // initialize DirectDraw
     gcSetConsole( 320, 200, BPP_8, SET_MODEX ); // set game console descriptor
     if (!gcInit( hwnd ))
	   return FALSE;
     gtState = GT_CRITICAL;  // initialize the game console
     return TRUE;
}

///////////////////////////////////////
// WndProc for Message Processing
///////////////////////////////////////
LRESULT APIENTRY WndFunc(HWND hwnd, UINT message, WPARAM wParam,LPARAM lParam)
{
	HDC         hdc;
	PAINTSTRUCT ps;
	
	switch (message)
	{
	case WM_PAINT:
		hdc = BeginPaint (hwnd, &ps);
		EndPaint (hwnd, &ps);
		return 0;
        case WM_SYSKEYUP:
		switch(wParam)
		{
                case VK_RETURN:
                        gcToggleWindow(hwnd);
                        if (bIsFullScreen == TRUE)
                          ShowCursor(FALSE);
			return 0;
		}
		return 0;
	case WM_KEYDOWN:
		switch(wParam)
		{
		case VK_ESCAPE:
			gtState = GT_END; // terminate gcApp
			return 0;
		}
		return 0;
	case WM_DESTROY:
		PostQuitMessage (0);
		return 0;
	}
	return DefWindowProc (hwnd, message, wParam, lParam);
}

///////////////////////////////////////
// Game Console Task Scheduler
///////////////////////////////////////
int gcScheduler( void )
{
  switch(gtState)
  {
    case GT_NONE:
      return 0;
	case GT_INIT:
	  return 0;
	case GT_CRITICAL:
	  gcUpdateSurface();
          gcEraseSurface(lpDDSOffScreen);
	  return 0;
	case GT_END:
	  gcFree();
      PostQuitMessage(0);
	  return 0;
	default:
	  break;
  }	// switch gtState
  return -1;
}
