///////////////////////////////////////
// File:      gcmodes.h
// Libraries: ddraw.lib
// Author:    Michael J. Norton
// Date:      082396
//
// pixelDyne copyright 1994,1995,1996
// Developer:  Date:     Comments 
// mjn         082396    game console alpha
// mjn         092396    flip mod for sysmem
///////////////////////////////////////
#define GCMODES_H_REV "gcmodes.h rev 1.02 112296 mjn pixelDyne"

#ifndef GCMODES_H_
#define GCMODES_H_

#include <ddraw.h>

#define TRIPLE_BUFFER    2  // 1 Primary + 2 Back 
#define DOUBLE_BUFFER    1  // 1 Primary + 1 Back
#define BPP_8            8  // 8 bits per pixel
#define BPP_16           16 // 16 bits per pixel
#define SET_MODEX     TRUE  // uses mode X
#define NO_MODEX      FALSE // not using mode X

//
// DirectDraw globals
//
extern LPDIRECTDRAW        lpDD;           // pointer to DirectDraw object
extern LPDIRECTDRAWSURFACE lpDDSPrimary;   // primary surface object
extern LPDIRECTDRAWSURFACE lpDDSBack;      // back surface object
extern LPDIRECTDRAWSURFACE lpDDSOffScreen; // offscreen surface

extern BOOL bDDEmulate;                  // emulate DirectDraw
extern BOOL bUseModeX;                   // use Mode X?
extern BOOL bIsFullScreen;               // use EXCLUSIVE mode
extern int  gcHeight;                    // console height (pixels)
extern int  gcWidth;                     // console width (pixels)
extern int  gcbpp;                       // console pixel bit depth 

///////////////////////////////////////
// externs
///////////////////////////////////////
extern void gcMsg( char *msg );
extern BOOL gcErrMsg( char *msg, BOOL retFlag );
extern void gcSetConsole( int width, int height, int bpp, int allowX );
extern BOOL gcInit( HWND hwnd );
//extern BOOL gcInit( HWND hwnd, int width, int height, int bpp, BOOL bmodeX );
extern void gcFreeDD( void );
extern BOOL gcSetCooperativeLevel( HWND hwnd );
extern BOOL gcSetVideoMode( HWND hwnd );
extern BOOL gcCreateSurfaces( void );
extern BOOL gcInitSurfaces(HWND hwnd);
extern void gcFreeSurfaces( void );
extern void gcEraseSurface(LPDIRECTDRAWSURFACE lpDDSurfPtr);
extern void gcFree( void );
extern void gcSetDesc( DWORD dwBufCount, DWORD dwFlags, DWORD dwCaps );
extern BOOL gcGetBackBuffer( void );
extern BOOL gcCreateOffScreen( void );
extern IDirectDrawSurface*  gcGetNewSurface( int width, int height, BOOL bSysMem );
extern BOOL gcCheckIsBankMem( void );
extern void gcUpdateSurface( void );
extern HRESULT gcRestoreSurfaces( void );
extern BOOL gcSetWindowMode( HWND hwnd );
extern BOOL gcCreateClipper( HWND hwnd );
extern BOOL gcToggleWindow(HWND hwnd);

#endif
