//  CHangman.h
//
//  Jasen N. Tenney
//	21 December 1995
//
//  Header file for CHangman class.
//

#ifndef CHANGMAN_H
#define CHANGMAN_H

class CHangman
{
protected:
	UINT			m_WordCount;			//Total # words in dictionary
	UINT			m_TotalGuesses;			//Total # of guesses so far
	UINT			m_GamesPlayed;			//Total # of games played so far
	UINT			m_GamesWon;				//Total # of games won
	UINT			m_Percentage;			//Percentage (ie GamesWon / GamesPlayed)
	UINT			m_GuessesRemaining;		//# of guesses left for this round
	UINT			m_NumValidGuesses;		//# of guesses allowed per round
	CStringArray	m_CurrentDictionary;	//All the words in the dictionary
	CString			m_CurrentWord;			//The current word to guess
	CString			m_CurrentGuess;			//The current guess so far

protected:
	CString InitCurrentGuess();				//Get a word out of dictionary

public:
	CHangman();								//Constructor
	~CHangman();							//Destructor
	BOOL CheckWordCompleted();				//Does m_CurrentGuess match m_CurrentWord
	BOOL CheckLetter(char Letter);			//Check if Letter is in m_CurrentWord
	BOOL LoadDictionary();					//Load the dictionary from disk
	CString GetCurrentWord();				//Return the current word	
	CString GetHintLetter();				//Return next letter in CurrentWord
	CString GetCurrentGuess();				//Return the current guess so far
	UINT GetTotalGuesses();					//Return total number of guesses so far
	UINT GetGuessRemain();					//Return # of guesses remaining
	UINT GetGamesWon();						//Return # of games won so far
	UINT GetGamesPlayed();					//Return # of games played so far
	UINT GetPercentage();					//Return the percentage so far
	void LoadNewWord();						//Load a new word into m_CurrentWord
	void IncrementTotalGuesses();			//Add one to total guesses
	void DecrementGuessRemain();			//Decrement guesses remaining 
	void IncrementGamesPlayed();			//Increment games played so far
	void IncrementGamesWon();				//Increment games won so far
	void Reset();							//Reset variables as if new game
	void LoadErrorDictionary();				//If can't load dictionary then do this
};

#endif