// TMemberCallback class
//
// Description:	This class provides the necessary functionality
//				requires by a C++ application to use a member function
//				as a Windows CALLBACK function.
//
// Author:		Weldon W. (Trey) Nash, III
//

// To inhibit multiple imclusion within compilation.
#ifndef __MEMDLL_H
   #define __MEMDLL_H

#include <windows.h>
#include <ddeml.h>
#include <stddef.h>
#include <_defs.h>

// This is an OWL thing.  It is only used to provide the CLASSDEF macro in
// order to facilitate automatic typedef creation.  The typedefs are used 
// in different ways to address objects as explained in the documentation.
// non-OWL users may need to remove this and supply the typedefs themselves.
#include <owldefs.h>

// These are OWL specific macros.  They basically provide a means to
// address objects by creating typedefs for the classes.  The macro
// is contained in owldefs.h.
_CLASSDEF(CODESTUB)
_CLASSDEF(CODESTUBNODE)
_CLASSDEF(TMEMBERCALLBACK)

// For the sake of forward referencing.
class _EXPORT TMemberCallback;

// This union is used to contain a pointer to the member function
// which is to be called by Windows.  It is contained in this union in
// order to facilitate type casting.
union CALLBACKPROC
{
	BOOL     CALLBACK  (TMemberCallback::*lpfnAbortProc)
	                    (HDC, int);
	LRESULT  CALLBACK  (TMemberCallback::*lpfnCallWndProc)
	                    (int, WPARAM, LPARAM);
	LRESULT  CALLBACK  (TMemberCallback::*lpfnCBTProc)
	                    (int, WPARAM, LPARAM);
	HDDEDATA CALLBACK  (TMemberCallback::*lpfnDdeCallback)
	                    (UINT, UINT, HCONV, HSZ, HSZ, HDDEDATA, DWORD, DWORD);
	LRESULT  CALLBACK  (TMemberCallback::*lpfnDebugProc)
	                    (int, WPARAM, LPARAM);
	BOOL     CALLBACK  (TMemberCallback::*lpfnDialogProc)
	                    (HWND, UINT, WPARAM, LPARAM);
	LRESULT  CALLBACK  (TMemberCallback::*lpfnDriverProc)
	                    (DWORD, HDRVR, UINT, LPARAM, LPARAM);
	BOOL     CALLBACK  (TMemberCallback::*lpfnEnumChildProc)
	                    (HWND, LPARAM);
	int      CALLBACK  (TMemberCallback::*lpfnEnumFontFamProc)
	                    (LOGFONT FAR*, TEXTMETRIC FAR*, int, LPARAM);
	int      CALLBACK  (TMemberCallback::*lpfnEnumFontsProc)
	                    (LOGFONT FAR*, NEWTEXTMETRIC FAR*, int, LPARAM);
	int      CALLBACK  (TMemberCallback::*lpfnEnumMetaFileProc)
	                    (HDC, HANDLETABLE FAR*, METARECORD FAR*, int, LPARAM);
	int      CALLBACK  (TMemberCallback::*lpfnEnumObjectsProc)
	                    (void FAR*, LPARAM);
	BOOL     CALLBACK  (TMemberCallback::*lpfnEnumPropFixedProc)
	                    (HWND, LPCSTR, HANDLE);
	BOOL     CALLBACK  (TMemberCallback::*lpfnEnumPropMovableProc)
	                    (HWND, LPCSTR, HANDLE);
	BOOL     CALLBACK  (TMemberCallback::*lpfnEnumTaskWndProc)
	                    (HWND, LPARAM);
	BOOL     CALLBACK  (TMemberCallback::*lpfnEnumWindowsProc)
	                    (HWND, LPARAM);
	LRESULT  CALLBACK  (TMemberCallback::*lpfnGetMsgProc)
	                    (int, WPARAM, LPARAM);
	BOOL     CALLBACK  (TMemberCallback::*lpfnGrayStringProc)
	                    (HDC, LPARAM, int);
	LRESULT  CALLBACK  (TMemberCallback::*lpfnHardwareProc)
	                    (int, WPARAM, LPARAM);
	LRESULT  CALLBACK  (TMemberCallback::*lpfnJournalPlaybackProc)
	                    (int, WPARAM, LPARAM);
	LRESULT  CALLBACK  (TMemberCallback::*lpfnJournalRecordProc)
	                    (int, WPARAM, LPARAM);
	LRESULT  CALLBACK  (TMemberCallback::*lpfnKeyboardProc)
	                    (int, WPARAM, LPARAM);
	void     CALLBACK  (TMemberCallback::*lpfnLineDDAProc)
	                    (int, int, LPARAM);
	HGLOBAL  CALLBACK  (TMemberCallback::*lpfnLoadProc)
	                    (HGLOBAL, HINSTANCE, HRSRC);
	LRESULT  CALLBACK  (TMemberCallback::*lpfnMessageProc)
	                    (int, WPARAM, LPARAM);
	LRESULT  CALLBACK  (TMemberCallback::*lpfnMouseProc)
	                    (int, WPARAM, LPARAM);
	BOOL     CALLBACK  (TMemberCallback::*lpfnNotifyProc)
	                    (HGLOBAL);
	LRESULT  CALLBACK  (TMemberCallback::*lpfnShellProc)
	                    (int, WPARAM, LPARAM);
	LRESULT  CALLBACK  (TMemberCallback::*lpfnSysMsgProc)
	                    (int, WPARAM, LPARAM);
	void     CALLBACK  (TMemberCallback::*lpfnTimerProc)
	                    (HWND, UINT, UINT, DWORD);
	LRESULT  CALLBACK  (TMemberCallback::*lpfnWindowProc)
	                    (HWND, UINT, WPARAM, LPARAM);
	int      CALLBACK  (TMemberCallback::*lpfnWordBreakProc)
	                    (LPSTR, int, int, int);

	FARPROC lpfn;
};   

// These are the typedefs that are required to cast the derived class's member
// functions into a member function type that TMemberCallback's class can
// use.
typedef BOOL     CALLBACK  (TMemberCallback::*LPFNABORTPROC)
                            (HDC, int);
typedef LRESULT  CALLBACK  (TMemberCallback::*LPFNCALLWNDPROC)
                            (int, WPARAM, LPARAM);
typedef LRESULT  CALLBACK  (TMemberCallback::*LPFNCBTPROC)
                            (int, WPARAM, LPARAM);
typedef HDDEDATA CALLBACK  (TMemberCallback::*LPFNDDECALLBACK)
                            (UINT, UINT, HCONV, HSZ, HSZ,
			                 HDDEDATA, DWORD, DWORD);
typedef LRESULT  CALLBACK  (TMemberCallback::*LPFNDEBUGPROC)
                            (int, WPARAM, LPARAM);
typedef BOOL     CALLBACK  (TMemberCallback::*LPFNDIALOGPROC)
                            (HWND, UINT, WPARAM, LPARAM);
typedef LRESULT  CALLBACK  (TMemberCallback::*LPFNDRIVERPROC)
                            (DWORD, HDRVR, UINT, LPARAM, LPARAM);
typedef BOOL     CALLBACK  (TMemberCallback::*LPFNENUMCHILDPROC)
                            (HWND, LPARAM);
typedef int      CALLBACK  (TMemberCallback::*LPFNENUMFONTFAMPROC)
                            (LOGFONT FAR*, TEXTMETRIC FAR*, int, LPARAM);
typedef int      CALLBACK  (TMemberCallback::*LPFNENUMFONTSPROC)
                            (LOGFONT FAR*, NEWTEXTMETRIC FAR*, int, LPARAM);
typedef int      CALLBACK  (TMemberCallback::*LPFNENUMMETAFILEPROC)
                            (HDC, HANDLETABLE FAR*, METARECORD FAR*, int, 
                             LPARAM);
typedef int      CALLBACK  (TMemberCallback::*LPFNENUMOBJECTSPROC)
                            (void FAR*, LPARAM);
typedef BOOL     CALLBACK  (TMemberCallback::*LPFNENUMPROPFIXEDPROC)
                            (HWND, LPCSTR, HANDLE);
typedef BOOL     CALLBACK  (TMemberCallback::*LPFNENUMPROPMOVABLEPROC)
                            (HWND, LPCSTR, HANDLE);
typedef BOOL     CALLBACK  (TMemberCallback::*LPFNENUMTASKWNDPROC)
                            (HWND, LPARAM);
typedef BOOL     CALLBACK  (TMemberCallback::*LPFNENUMWINDOWSPROC)
                            (HWND, LPARAM);
typedef LRESULT  CALLBACK  (TMemberCallback::*LPFNGETMSGPROC)
                            (int, WPARAM, LPARAM);
typedef BOOL     CALLBACK  (TMemberCallback::*LPFNGRAYSTRINGPROC)
                            (HDC, LPARAM, int);
typedef LRESULT  CALLBACK  (TMemberCallback::*LPFNHARDWAREPROC)
                            (int, WPARAM, LPARAM);
typedef LRESULT  CALLBACK  (TMemberCallback::*LPFNJOURNALPLAYBACKPROC)
                            (int, WPARAM, LPARAM);
typedef LRESULT  CALLBACK  (TMemberCallback::*LPFNJOURNALRECORDPROC)
                            (int, WPARAM, LPARAM);
typedef LRESULT  CALLBACK  (TMemberCallback::*LPFNKEYBOARDPROC)
                            (int, WPARAM, LPARAM);
typedef void     CALLBACK  (TMemberCallback::*LPFNLINEDDAPROC)
                            (int, int, LPARAM);
typedef HGLOBAL  CALLBACK  (TMemberCallback::*LPFNLOADPROC)
                            (HGLOBAL, HINSTANCE, HRSRC);
typedef LRESULT  CALLBACK  (TMemberCallback::*LPFNMESSAGEPROC)
                            (int, WPARAM, LPARAM);
typedef LRESULT  CALLBACK  (TMemberCallback::*LPFNMOUSEPROC)
                            (int, WPARAM, LPARAM);
typedef BOOL     CALLBACK  (TMemberCallback::*LPFNNOTIFYPROC)
                            (HGLOBAL);
typedef LRESULT  CALLBACK  (TMemberCallback::*LPFNSHELLPROC)
                            (int, WPARAM, LPARAM);
typedef LRESULT  CALLBACK  (TMemberCallback::*LPFNSYSMSGPROC)
                            (int, WPARAM, LPARAM);
typedef void     CALLBACK  (TMemberCallback::*LPFNTIMERPROC)
                            (HWND, UINT, UINT, DWORD);
typedef LRESULT  CALLBACK  (TMemberCallback::*LPFNWINDOWPROC)
                            (HWND, UINT, WPARAM, LPARAM);
typedef int      CALLBACK  (TMemberCallback::*LPFNWORDBREAKPROC)
                            (LPSTR, int, int, int);

// This structure comprises the code stub that Windows will end up
// calling.  It provides the member function with the hidden 'this'
// pointer.
struct CODESTUB
{
  	BYTE    asmBlock1[3];
	WORD    segProc;
	BYTE    asmBlock2;
	WORD    offProc;
	BYTE    asmBlock3[3];
	WORD    segDataInst;
	BYTE    asmBlock4;
	FARPROC lpfn;

    void * operator new(size_t size);
	void operator delete(void* pDeadObject);
};

// This structure comprises the CODESTUB linked list nodes.
// Upon creation, it is passed a pointer which will point to the
// next node of the list.  Each node is inserted at the head of
// the list.
struct CODESTUBNODE
{
    PCODESTUB lpCodeStub;
    PCODESTUBNODE lpNext;
    
    CODESTUBNODE(PCODESTUBNODE lpCodeStubNode = NULL);
    ~CODESTUBNODE();
};

// This class is meant to be inherited by the class which wishes to 
// have a member as a callback function.  It cannot be instantiated on
// its own.  
class _EXPORT TMemberCallback
{
   private:
      PCODESTUBNODE lpCodeStubHead;
   
   protected:
      // Protected constructor keeps the programmer from instantiating a
      // TMemberCallback object.  It can only be used through inheritance.
      TMemberCallback();
      ~TMemberCallback();
      BOOL FreeProcInstance(FARPROC lpCodeStub);
      FARPROC MakeProcInstance(CALLBACKPROC CallbackProc, HINSTANCE hInstance);
};

#endif                           