///////////////////////////////////////////////////////////////////////////////
//Brad Johnson Console Telnet a Win32 ANSI telnet client.
//Copyright (C) 1997  Brad Johnson
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//jbj@chrysalis.org
//brad.johnson@chrysalis.org
//
//Brad Johnson
//P.O. Box 933
//Crowley, TX 76036
//
///////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//
// Module:		ansiprsr.cpp
//
// Contents:	ANSI parser base class
//
// Product:		telnet
//
// Revisions: 05. Sep.1997 roryt@hol.gr (I.Ioannou)
//            11.May.1997  roryt@hol.gr (I.Ioannou)
//            6.April.1997 roryt@hol.gr (I.Ioannou)
//            5.April.1997 jbj@chrysalis.org
//            30.Mrz.1997	Titus_Boxberg@public.uni-hamburg.de
//		        14.Sept.1996 jbj@chrysalis.org
//            Version 2.0
//
//            13.Jul.1995	igor.milavec@uni-lj.si
//					  Original code
//
///////////////////////////////////////////////////////////////////////////////

//#define DEBUG_TELOPT

#include "ansiprsr.h"

TANSIParser::TANSIParser(char * szDumpFileName, char * pcSD, long iSS, long * iSB){
  piScrollBegin = iSB;
  pcScrollData = pcSD;
  iScrollSize = iSS;
  bInEchoTx = 0;
  bInEchoRx = 0;
  bGraphChar = 0;
  bInBinaryRx = 0;
  bInBinaryTx = 0;
  iSavedCurY = 0;
  iSavedCurX = 0;
  inGraphMode = 0;
  iScrollStart = -1;
  iScrollEnd = -1;
  iSavedAttributes = (unsigned char) 7;
  iTermSet=0;
  szBuffer[ANSI_BUFFER_SIZE];
  pszTail = szBuffer;
  pszHead = szBuffer;
  if ( szDumpFileName != NULL){
     dumpfile = fopen( szDumpFileName, "wb");
  }else {
     dumpfile = NULL;
  }
  InPrintMode = 0;
  printfile = NULL;
}

TANSIParser::~TANSIParser(){
  if (dumpfile)
     fclose (dumpfile);
// Added I.Ioannou 06 April, 1997
  if (printfile != NULL)
     fclose (printfile);
}

void TANSIParser::SaveCurY(int iY){
  iSavedCurY=iY;
}

void TANSIParser::SaveCurX(int iX){
  iSavedCurX=iX;
}

int TANSIParser::ConSetAttribute(int TextAttrib){
  switch (TextAttrib){
     // Text Attributes
     case 0: ConNormal();           break; //Normal video
     case 1: ConHighVideo();        break; //High video
     case 2: ConLowVideo();         break; //Low video
     case 4:                        break; // Underline on (I.Ioannou)
     case 5: ConBlink();            break; //Blink video
// Corrected by I.Ioannou 11 May, 1997
     case 7: ConReverseOn();        break; //Reverse video
     case 8:                        break; // hidden
// All from 10 thru 27 are hacked from linux kernel
// I.Ioannou 06 April, 1997
     case 10:
//  I.Ioannou 04 Sep 1997 turn on/off high bit
                                    inGraphMode = 0;
                                    break; // ANSI X3.64-1979 (SCO-ish?)
                                           // Select primary font,
                                           // don't display control chars
                                           // if defined, don't set
                                           // bit 8 on output (normal)
     case 11:                       break; // ANSI X3.64-1979 (SCO-ish?)
                                           // Select first alternate font,
                                           // let chars < 32 be displayed
                                           // as ROM chars
     case 12:                       inGraphMode = 1;
                                    break; // ANSI X3.64-1979 (SCO-ish?)
                                           // Select second alternate font,
                                           // toggle high bit before
                                           // displaying as ROM char.

     case 21:                             // not really Low video
     case 22: ConLowVideo();        break; // but this works good also
     case 24:                       break; // Underline off
     case 25: ConBlinkOff();        break; // blink off
     // Corrected by I.Ioannou 11 May, 1997
     case 27: ConReverseOff();      break; //Reverse video off
     // Foreground colors
     case 30: ConForground(BLACK);  break; //Black
     case 31: ConForground(RED);    break; //Red
     case 32: ConForground(GREEN);  break; //Green
     case 33: ConForground(YELLOW); break; //Yellow
     case 34: ConForground(BLUE);   break; //Blue
     case 35: ConForground(MAGENTA);break; //Magenta
     case 36: ConForground(CYAN);   break; //Cyan
     case 37: ConForground(WHITE);  break; //White
     // Background colors
     case 40: ConBackground(BLACK); break; //Black
     case 41: ConBackground(RED);   break; //Red
     case 42: ConBackground(GREEN); break; //Green
     case 43: ConBackground(YELLOW);break; //Yellow
     case 44: ConBackground(BLUE);  break; //Blue
     case 45: ConBackground(MAGENTA);break; //Magenta
     case 46: ConBackground(CYAN);  break; //Cyan
     case 47: ConBackground(WHITE); break; //White
  }
  return 1;
}


char* TANSIParser::GetTerminalId()
{
	return "\033[?1;2c";
}

int escapeIAC( char * buf, int length ){
  // The size of buffer must be greater than 2 * length to ensure no memory
  // out of bounds errors.  The 0xff is escaped into 0xff 0xff.
  char * temp;
  temp = new char [length * 2];
  int current=0;
  for (int x=0; x < length; x++){
    if (buf[x] == IAC)
       temp[current++]=IAC;
    temp[current++]=buf[x];
  }
  memcpy( buf, temp, current);
  delete [] temp;
  return current;
}


char* TANSIParser::ParseIAC(char* pszBuffer, char* pszBufferEnd)
{
  #define LASTTERM 3
  int n,l;
  char *pszTerms[] =  {"ANSI","DEC-VT100","DEC-VT52","UNKNOWN"};
  char szResponse[40];
	if (pszBuffer + 2 < pszBufferEnd) {
		switch ((unsigned char)pszBuffer[1]) {

///////////////// DO ////////////////////

		  case DO: {
        switch (pszBuffer[2]){
          case TELOPT_BINARY:
#ifdef DEBUG_TELOPT
        printf("RCVD DO TELOPT_BINARY\n");
#endif
            if (!bInBinaryRx){
              sprintf(szResponse, "%c%c%c", IAC, WILL, TELOPT_BINARY);
              NetWriteString(szResponse, 3);
              bInBinaryRx = 1;
#ifdef DEBUG_TELOPT
        printf("SENT WILL TELOPT_BINARY\n");
#endif
            }
            break;
          case TELOPT_ECHO:
#ifdef DEBUG_TELOPT
        printf("RCVD DO TELOPT_ECHO, %i\n", pszBuffer[2]);
#endif
            if (!bInEchoTx){
               sprintf(szResponse, "%c%c%c", IAC, WILL, TELOPT_ECHO);
               NetWriteString(szResponse, 3);
               bInEchoTx = 1;
#ifdef DEBUG_TELOPT
        printf("SENT WILL TELOPT_ECHO\n");
#endif
            }
            break;
          case TELOPT_TTYPE:
#ifdef DEBUG_TELOPT
        printf("RCVD DO TELOPT_TTYPE\n");
#endif
            sprintf(szResponse, "%c%c%c", IAC, WILL, TELOPT_TTYPE);
            NetWriteString(szResponse, 3);
#ifdef DEBUG_TELOPT
        printf("SENT WILL TELOPT_TTYPE\n");
#endif
            break;
          case TELOPT_NAWS:
#ifdef DEBUG_TELOPT
        printf("RCVD DO TELOPT_NAWS\n");
#endif
            sprintf(szResponse, "%c%c%c", IAC, WILL, TELOPT_NAWS);
            NetWriteString(szResponse, 3);
            //IAC SB NAWS <16-bit value> <16-bit value> IAC SE
            sprintf(szResponse, "%c%c%c", IAC, SB, TELOPT_NAWS );
            NetWriteString(szResponse,3);

            n = ConGetWidth();
            szResponse[1] = ((unsigned char *) &n) [0];
            szResponse[0] = ((unsigned char *) &n) [1];
            l = escapeIAC( szResponse, 2 );
            NetWriteString(szResponse,l);

            n = ConGetHeight();
            szResponse[1] = ((unsigned char *) &n) [0];
            szResponse[0] = ((unsigned char *) &n) [1];
            l = escapeIAC( szResponse, 2 );
            NetWriteString(szResponse,l);

            sprintf(szResponse, "%c%c", IAC, SE );
            NetWriteString(szResponse,2);
#ifdef DEBUG_TELOPT
        printf("SENT WILL TELOPT_NAWS\n");
#endif
            break;
          default:
#ifdef DEBUG_TELOPT
        printf("RCVD DO %i\n", pszBuffer[2]);
#endif
            sprintf(szResponse, "%c%c%c", IAC, WONT, pszBuffer[2]);
            NetWriteString(szResponse, 3);
#ifdef DEBUG_TELOPT
        printf("SENT WONT %i\n", pszBuffer[2]);
#endif
            break;
        }
        if (pszBuffer + 2 < pszBufferEnd)
          pszBuffer += 3;
        break;
		  }

///////////////// WILL ////////////////////
		  case WILL:
          switch ((unsigned char)pszBuffer[2]){
            case TELOPT_BINARY:
#ifdef DEBUG_TELOPT
          printf("RCVD WILL TELOPT_BINARY\n");
#endif
              if (!bInBinaryTx){
                sprintf(szResponse, "%c%c%c", IAC, DO, TELOPT_BINARY);
                NetWriteString(szResponse, 3);
                bInBinaryTx = 1;
#ifdef DEBUG_TELOPT
        printf("SENT DO TELOPT_BINARY\n");
#endif
              }
              break;
            case TELOPT_ECHO:
#ifdef DEBUG_TELOPT
          printf("RCVD WILL TELOPT_ECHO, %i\n", pszBuffer[2]);
#endif
              if (!bInEchoRx){
                sprintf(szResponse, "%c%c%c", IAC, DO, TELOPT_ECHO);
                NetWriteString(szResponse, 3);
                bInBinaryRx = 1;
#ifdef DEBUG_TELOPT
        printf("SENT DO TELOPT_ECHO, %i\n", pszBuffer[2]);
#endif
              }
              break;
////added 1/28/97
            default:
#ifdef DEBUG_TELOPT
          printf("RCVD WILL %i\n", pszBuffer[2]);
#endif
              sprintf(szResponse, "%c%c%c", IAC, DONT, pszBuffer[2]);
              NetWriteString(szResponse, 3);
#ifdef DEBUG_TELOPT
        printf("SENT DONT %i\n", pszBuffer[2]);
#endif
              break;
////
          }
          if (pszBuffer + 2 < pszBufferEnd)
            pszBuffer += 3;
          break;

///////////////// WONT ////////////////////
		  case WONT:
          switch ((unsigned char)pszBuffer[2]){
            case TELOPT_ECHO:
#ifdef DEBUG_TELOPT
        printf("RCVD WONT TELOPT_ECHO\n");
#endif
              if (bInEchoRx){
                sprintf(szResponse, "%c%c%c", IAC, DONT, TELOPT_ECHO);
                NetWriteString(szResponse, 3);
                bInBinaryRx = 0;
#ifdef DEBUG_TELOPT
        printf("SENT DONT TELOPT_ECHO\n");
#endif
              }
              break;
            default:
#ifdef DEBUG_TELOPT
        printf("RCVD WONT %i\n", pszBuffer[2]);
#endif
              break;
          }
          if (pszBuffer + 2 < pszBufferEnd)
            pszBuffer += 3;
          break;

///////////////// DONT ////////////////////
		  case DONT:
          switch ((unsigned char)pszBuffer[2]){
            case TELOPT_ECHO:
#ifdef DEBUG_TELOPT
        printf("RCVD DONT TELOPT_ECHO\n");
#endif
              if (bInEchoTx){
                sprintf(szResponse, "%c%c%c", IAC, WONT, TELOPT_ECHO);
                NetWriteString(szResponse, 3);
                bInBinaryTx = 0;
#ifdef DEBUG_TELOPT
        printf("SENT WONT TELOPT_ECHO\n");
#endif
              }
              break;
            default:
#ifdef DEBUG_TELOPT
        printf("RCVD DONT %i\n", pszBuffer[2]);
#endif
              break;
          }
          if (pszBuffer + 2 < pszBufferEnd)
            pszBuffer += 3;
          break;
///////////////// SB ////////////////////
        case SB:
#ifdef DEBUG_TELOPT
        printf("RCVD SB %i\n", pszBuffer[2]);
#endif
           switch ((unsigned char)pszBuffer[2]){
             case TELOPT_TTYPE:
               if (pszBuffer + 5 < pszBufferEnd) {
                 if (pszBuffer[3] == 1){
   #ifdef DEBUG_TELOPT
                   printf("SENT SB TT %s\n", pszTerms[iTermSet]);
   #endif
                   sprintf(szResponse, "%c%c%c%c%s%c%c",
                     IAC,SB, TELOPT_TTYPE, 0, pszTerms[iTermSet], IAC, SE);
                   NetWriteString(szResponse, 6+strlen(pszTerms[iTermSet]));
                   if (iTermSet < LASTTERM )
                     iTermSet+=1;
                 }
               if (pszBuffer + 5 < pszBufferEnd)
                 pszBuffer += 6;
               break;
             }
             default: break;
           }
           break;
		  default:
          pszBuffer += 2;
          break;
		}
	}
	return pszBuffer;
}


#pragma argsused
char* TANSIParser::ParseEscapeANSI(char* pszBuffer, char* pszBufferEnd)
{
//	The buffer contains something like <ESC>[pA
//	where p is an optional decimal number specifying the count by which the
//	appropriate action should take place.
//	The pointer pszBuffer points us to the p, <ESC> and [ are
//	already 'consumed'

//	TITUS: Simplification of the code: Assume default count of 1 in case
//	there are no parameters.
	char	tmpc;
	const int nParam = 10;	// Maximum number of parameters
	int iParam[nParam] = {1, 0, 0, 0, 0};	// Assume 1 Parameter, Default 1
	int iCurrentParam = 0;

	// Get parameters from escape sequence.
	while ( isdigit((tmpc = *pszBuffer)) || tmpc == ';' || tmpc == '?' ) {

		// Check for parameter delimiter.
		if (tmpc == ';') {
			pszBuffer++;
			continue;
		} /* IF */
		if (tmpc == '?') {
			pszBuffer++;
			continue;
		} /* IF */
//  Got Numerical Parameter.
		iParam[iCurrentParam] = strtoul(pszBuffer, &pszBuffer, 10);
		if (iCurrentParam < nParam)
			iCurrentParam++;
	} /* WHILE */

//~~~ TITUS: Apparently the digit is optional (look at termcap or terminfo)
// So: If there is no digit, assume a count of 1

	switch ((unsigned char)*pszBuffer++) {

	  // Insert Character
	  case '@':
	    InsertCharacter(iParam[0]);
	    break;


	  // Move cursor up.
	  case 'A':
		ConMoveCursorPosition(0, -iParam[0]);
		break;

	  // Move cursor down.
	  case 'B':
    case 'e':  // Added by I.Ioannou 06 April, 1997
		ConMoveCursorPosition(0, iParam[0]);
		break;

	  // Move cursor right.
	  case 'C':
    case 'a':  // Added by I.Ioannou 06 April, 1997
		ConMoveCursorPosition(iParam[0], 0);
		break;

	  // Move cursor left.
	  case 'D':
		ConMoveCursorPosition(-iParam[0], 0);
		break;

    // Move cursor to beginning of line, p lines down.
    // Added by I.Ioannou 06 April, 1997
    case 'E':
      ConMoveCursorPosition(-ConGetCursorX(), iParam[0]);
      break;

    //  Moves active position to beginning of line, p lines up
    // Added by I.Ioannou 06 April, 1997
    case 'F':
      ConMoveCursorPosition(-ConGetCursorX(), -iParam[0]);
      break;

    // Go to column p
    // Added by I.Ioannou 06 April, 1997
    case '`':
    case 'G':   // 'G' is from Linux kernel sources
      if (iCurrentParam < 1)			// Alter Default
        iParam[0] = 0;
      ConSetCursorPosition(ConGetCursorX(), iParam[0]);
      break;


	  // Set cursor position.
//    case 'F':  Correction by I.Ioannou 06 April, 1997
	  case 'f':
	  case 'H':
		if (iCurrentParam < 2 || iParam[1] < 1)
			iParam[1] = 1;
		ConSetCursorPosition(iParam[1] - 1,	iParam[0] - 1);
		break;


    // Clear screen
	  case 'J': {
            if ( iCurrentParam < 1 ) iParam[0] = 0;	// Alter Default
      switch (iParam[0]) {
        case 0:
        ConClearEOScreen();
        break;
        case 1:
        ConClearBOScreen();
        break;
        case 2:
        ConClearScreen();
	    	ConSetCursorPosition(0, 0);
        break;
      }
      break;
	  }

    // Clear line
	  case 'K':	{
      if (iCurrentParam < 1)			// Alter Default
        iParam[0] = 0;
      switch (iParam[0]) {
        case 0:
        ConClearEOLine();
        break;
        case 1:
        ConClearBOLine();
        break;
        case 2:
        ConClearLine();
        break;
      }
  		break;
	  }

    //  Insert p new, blank lines.
    // Added by I.Ioannou 06 April, 1997
    case 'L': {
      for ( int i = 1; i<= iParam[0]; i++ )
        ConScrollDown(  ConGetCursorY(), -1, 1 );
      break;
    }

    //  Delete p lines.
    // Added by I.Ioannou 06 April, 1997
    case 'M': {
      for ( int i = 1; i<= iParam[0]; i++ )
        ConScrollDown(  ConGetCursorY(), -1, 0 );
      break;
    }

// DELETE CHAR
     case 'P':
       DeleteCharacter(iParam[0]);
       break;

    // Scrolls screen up p lines,
    // Added by I.Ioannou 06 April, 1997
    // ANSI X3.64-1979 references this but I didn't
    // found it in any telnet implementation
		// note 05 Oct 97  : but SCO terminfo uses them, so uncomment them !!
      case 'S': {
      for ( int i = 1; i<= iParam[0]; i++ )
        ConScrollDown(  -1, -1, 0 );
      break;
    }


    // Scrolls screen up p lines,
    // Added by I.Ioannou 06 April, 1997
    // ANSI X3.64-1979 references this but I didn't
    // found it in any telnet implementation
		// note 05 Oct 97  : but SCO terminfo uses them, so uncomment them !!
      case 'T': {
      for ( int i = 1; i<= iParam[0]; i++ )
        ConScrollDown(  -1, -1, 1 );
      break;
    }


    //  Erases p characters up to the end of line
    // Added by I.Ioannou 06 April, 1997
    case 'X': {
      int iKeepX = ConGetCursorX();
      int iKeepY = ConGetCursorY();

      if (iParam[0] > ConGetWidth())
         iParam[0] = ConGetWidth(); // up to the end of line
      for ( int i = 1; i <= iParam[0]; i++ )
      {
        ConWriteString(" ", 1);
      }
      ConSetCursorPosition(iKeepX , iKeepY);
      break;
    }

    // Go back p tab stops
    // Added by I.Ioannou 06 April, 1997
    // FIX ME. How do we implement this ?
    case 'Z':
      break;

    // Get Terminal ID
 	  case 'c': {
		char* szTerminalId = GetTerminalId();
		NetWriteString(szTerminalId, strlen(szTerminalId));
		break;
	  }

    // Go to line p
    // Added by I.Ioannou 06 April, 1997
    case 'd':
      if (iCurrentParam < 1)			// Alter Default
        iParam[0] = 0;
      ConSetCursorPosition(iParam[0], ConGetCursorY());
      break;

    // iBCS2 tab erase
    // Added by I.Ioannou 06 April, 1997
    case 'g':
      if (iCurrentParam < 1)			// Alter Default
        iParam[0] = 0;
      switch (iParam[0]) {
        case 0: // FIX ME. If iBCS2 compliance is selected
                // clear the horizontal tab stop at the
                // current active position
          break;
        case 3: // FIX ME. If iBCS2 compliance
                // is selected , clear all
                // horizontal tab stops.
          break;
      }
      break;

    // Set extended mode
	  case 'h': {
		  for (int i = 0; i < iCurrentParam; i++)
        if (iParam[i]==7)
          ConLineWrap( 1 );
        else
			 ConSetExtendedMode(iParam[i], 1);
        break;
	  }

    // Print Screen
    case 'i': {
      if (iCurrentParam < 1)
        iParam[0]=0;
      switch (iParam[0]){
        case 0: break; // Print Screen
        case 1: break; // Print Line
        // Added I.Ioannou 06 April, 1997
        case 4: InPrintMode = 0; // Stop Print Log
                if ( printfile != NULL )
                  fclose(printfile);
                break;
        case 5: printfile = fopen("LPT1", "ab");  // Start Print Log
                if (printfile != NULL)
                {
                  InPrintMode = 1;
                  return pszBuffer;
                }
                break;
      }
    break;
    }

    // Set extended mode
	  case 'l': {
        for (int i = 0; i < iCurrentParam; i++)
          if (iParam[i]==7)
            ConLineWrap( 0 );
          else
            ConSetExtendedMode(iParam[i], 0);
      break;
    }

    // Set color
    case 'm': {
      if (iCurrentParam == 0){
        ConNormal();
        break;
      }
      else{
        for (int i = 0; i < iCurrentParam; i++)
          ConSetAttribute(iParam[i]);
        break;
      }
    }

    // report cursor position Row X Col
    case 'n': {
      char szCursorReport[20];
      if (iCurrentParam == 1 && iParam[0]==5){
        sprintf(szCursorReport,"\x1B[0n");
     		NetWriteString(szCursorReport, strlen(szCursorReport));
        // report the cursor position
      }
      if (iCurrentParam == 1 && iParam[0]==6){
        sprintf(szCursorReport,"\x1B[%i;%iR",ConGetCursorX()+1,ConGetCursorY()+1);
     		NetWriteString(szCursorReport, strlen(szCursorReport));
        // report the cursor position
      }
      break;
    }

    // Scroll Screen
    case 'r': {
      if (iCurrentParam < 1){
        // Enable scrolling for entire display
        iScrollStart = -1;
        iScrollEnd = -1;
      }
      if (iCurrentParam >1){
        // Enable scrolling from row1 to row2
        iScrollStart = iParam[0] - 1;
        iScrollEnd = iParam[1] - 1;
      }
      break;
    }

    // Save cursor position
    case 's': {
    SaveCurY(ConGetCursorY());
    SaveCurX(ConGetCursorX());
    break;
    }

    // Restore cursor position
    case 'u': {
		  ConSetCursorPosition(iSavedCurX, iSavedCurY);
    break;
    }
  }
	return pszBuffer;
}

char* TANSIParser::ParseEscape(char* pszBuffer, char* pszBufferEnd)
{
	// Check if we have enough characters in buffer.
	if ((pszBufferEnd - pszBuffer) < 2)
		return pszBuffer;

//  I.Ioannou 04 Sep 1997
// there is no need for pszBuffer++; after each command

  // Decode the command.
  pszBuffer++;
	switch (*pszBuffer++) {
    // Cursor up
	  case 'A':
  		ConMoveCursorPosition(0, -1);
      pszBuffer++;
	  	break;

    // Cursor down
	  case 'B':
  		ConMoveCursorPosition(0, 1);
      pszBuffer++;
	  	break;

    // Cursor right
	  case 'C':
  		ConMoveCursorPosition(1, 0);
      pszBuffer++;
	  	break;

    // Scroll down 1 line
	  case 'D':
      ConScrollDown( iScrollStart , iScrollEnd, 0 );
      pszBuffer++;
	  	break;

    // Special graphics char set
	  case 'F':
    pszBuffer++;
	  break;

    // ASCII char set
	  case 'G':
    pszBuffer++;
  break;

    // Home cursor
	  case 'H':
//  I.Ioannou 04 Sep 1997 (0,0) not (1,1)
    ConSetCursorPosition(0, 0);
    pszBuffer++;
	  break;

    // Erase end of screen
	  case 'I':
    ConClearBOScreen();
    pszBuffer++;
	  break;

    // Erase EOL
	  case 'J':
    ConClearEOLine();
    pszBuffer++;
	  break;

    // Scroll Up one line //Reverse index
    case 'M': {
      ConScrollDown( iScrollStart , iScrollEnd, 1 );
      break;
    }

    // Direct cursor addressing
	  case 'Y':
    if ((pszBufferEnd - pszBuffer) >= 4){
  		ConSetCursorPosition(pszBuffer[2]- '\x1F',pszBuffer[1]-'\x1F');
    	pszBuffer+=3;
    }
	  break;

    // Identify
//	  case 'Z':
// 		NetWriteString("\x1BZ", 2);
//  	pszBuffer++;
//	  break;

    // Terminal ID Request
	  case 'Z': {
		char* szTerminalId = GetTerminalId();
		NetWriteString(szTerminalId, strlen(szTerminalId));
		break;
	  }

    // reset terminal to defaults
    case 'c': {
      iSavedCurY = 0;            // Reset Variables
      iSavedCurX = 0;
      iScrollStart = -1;
      iScrollEnd = -1;
      ConNormal();               // Reset Attributes
      ConClearScreen();          // Clear Screen
   		ConSetCursorPosition(0,0); // Home Cursor
      break;
    }

    //ESC =           Enter alternate keypad mode
	  case '=':
    pszBuffer++;
	  break;

    //ESC >           Exit alternate keypad mode
	  case '>':
    pszBuffer++;
	  break;

    //ESC <           Enter ANSI mode
	  case '<':
    pszBuffer++;
	  break;

    //ESC 1           Graphics processor on (See note 3)
	  case '1':
    pszBuffer++;
	  break;

     case '#':        //Line size commands
     pszBuffer++;
     break;

    //ESC 2           Graphics processor off (See note 3)
	  case '2':
    pszBuffer++;
	  break;

    // Save cursor and attribs
    case '7': {
      SaveCurY(ConGetCursorY());
      SaveCurX(ConGetCursorX());
      iSavedAttributes = ConGetAttrib();
      break;
    }

    // Restore cursor position and attribs
    case '8': {
		  ConSetCursorPosition(iSavedCurX, iSavedCurY);
      ConSetAttrib(iSavedAttributes);
      break;
    }

    // Set Mode
	  case '(':
    pszBuffer++;
		break;

    // Set Mode
	  case ')':
    pszBuffer++;
		break;

    // ANSI escape sequence
	  case '[': {
		// Check if we have whole escape sequence in buffer.
		char* pszChar = pszBuffer;
		while ((pszChar < pszBufferEnd) && (!isalpha(*pszChar)))
			pszChar++;
		if (pszChar == pszBufferEnd)
			pszBuffer -= 2;
		else
			pszBuffer = ParseEscapeANSI(pszBuffer, pszBufferEnd);
		break;
	  }

	}
	return pszBuffer;
}

char* TANSIParser::ParseBuffer(char* pszBuffer1, char* pszBufferEnd1){
  // copy into ANSI buffer
  char * pszResult;
  while (pszBuffer1 < pszBufferEnd1 && pszTail < (szBuffer + ANSI_BUFFER_SIZE)){
    // if IAC then parse IAC
    if ((unsigned char) *pszBuffer1 == IAC){

      // check for escaped IAC
      if ((unsigned char) *pszBuffer1+1 == IAC && pszBufferEnd1 >= pszBuffer1+1){
        *pszTail = *pszBuffer1;
        pszBuffer1+=2;
        pszTail++;
      }
      // parse the IAC
      else{
         pszResult = ParseIAC(pszBuffer1, pszBufferEnd1);
         if (pszBuffer1 == pszResult){
           return pszBuffer1;
         }
         pszBuffer1 = pszResult;
      }
    }
    // else copy char over to ANSI buffer
    else {
      *pszTail = *pszBuffer1;
      pszTail++;
      // do the next char
      pszBuffer1++;
    }
  }
  // Maintain the buffer ,if at the end move up
  if (pszTail == (szBuffer + ANSI_BUFFER_SIZE)) {
    MoveMemory(szBuffer, pszHead, pszTail - pszHead);
    pszTail = szBuffer + (pszTail - pszHead);
    pszHead = szBuffer;
  }
  // Parse the buffer for ANSI or display
  while (pszHead < pszTail) {
    pszResult = ParseANSIBuffer(pszHead, pszTail);
    if (dumpfile)
      fwrite( pszHead, sizeof (char), pszResult-pszHead , dumpfile);
    if (pcScrollData){
//      printf("%i %i",piScrollBegin, pszResult-pszHead);
      if ((*piScrollBegin)+(pszResult-pszHead) < iScrollSize){
        MoveMemory( &pcScrollData[*piScrollBegin], pszHead, pszResult-pszHead );
      }
      else{
        MoveMemory( &pcScrollData[*piScrollBegin],pszHead ,iScrollSize-*piScrollBegin);
        MoveMemory( &pcScrollData[0],pszHead,pszResult-pszHead -(iScrollSize-*piScrollBegin));
      }
      *piScrollBegin = ((*piScrollBegin)+(pszResult-pszHead))%iScrollSize;
    }
    if (pszResult == pszHead) break;
    pszHead = pszResult;
  }
  // return the new head to the buffer
  return pszBuffer1;
}

char* TANSIParser::ParseANSIBuffer(char* pszBuffer, char* pszBufferEnd)
{
  if ( InPrintMode )
  {
     return PrintBuffer(pszBuffer, pszBufferEnd);
  }
	switch (*(unsigned char *)pszBuffer) {

	  case 0:
		pszBuffer++;
		break;

    // destructive backspace
	  case 8:
//    ConWriteString("\b \b", 3);
    ConWriteString("\b", 1);
    pszBuffer++;
    break;

    // horizontal tab
	  case 9:
    pszBuffer++;
    ConWriteCtrlString("\x09");
    break;

    // Line Feed Char
    case 10:
		pszBuffer++;
    ConWriteCtrlString("\x0a");
		break;

    // form feed
	  case 12:
		pszBuffer++;
		ConClearScreen();
		ConSetCursorPosition(ConGetCursorX(), 1); // changed fm 1
		break;

    case 13:
		pszBuffer++;
    ConWriteCtrlString("\x0d");
		break;
    case 14:  // shift out of alternate chararcter set
		pszBuffer++;
      bGraphChar = 1;
		break;
    case 15:  // shift in
		pszBuffer++;
      bGraphChar = 0;
      break;

	  case 27:
		pszBuffer = ParseEscape(pszBuffer, pszBufferEnd);
		break;


//  added by I.Ioannou 06 April, 1997
//  In 8 bit systems the server may send 0x9b instead of ESC[
//  Well, this will produce troubles in Greek 737 Code page
//  which uses 0x9b as the small "delta" - and I thing that there
//  is another European country with the same problem.
//  If we have to stay 8-bit clean we may have to
//  give the ability of ROM characters (ESC[11m),
//  for striped 8'th bit (ESC[12m) as SCO does,
//  or a parameter at compile (or run ?) time.
#if defined (USE_0x9b)
    case 128+27:
    {
		// Check if we have whole escape sequence in buffer.
		char* pszChar = pszBuffer;
		while ((pszChar < pszBufferEnd) && (!isalpha(*pszChar)))
			pszChar++;
		if (pszChar == pszBufferEnd)
			pszBuffer -= 2;
		else
			pszBuffer = ParseEscapeANSI(pszBuffer, pszBufferEnd);
		break;
    }
#endif // defined (USE_0x9b)

	  default: {
         if (!bGraphChar){
            char* pszCurrent = pszBuffer + 1;
// I.Ioannou 04 Sep 1997 FIXME with ESC[11m must show chars < 32
            while ((pszCurrent < pszBufferEnd) &&
                   (!iscntrl(*pszCurrent))     &&
                   (*pszCurrent != (char)10)   &&
                   (*pszCurrent != (char)13)   &&
                   (*pszCurrent != (char)8 )   &&
                   (*pszCurrent != (char)27))
            {
// I.Ioannou 04 Sep 1997 strip on high bit
              if ( (inGraphMode) && (*pszCurrent > (char)32) )
                 *pszCurrent |= 0x80 ;
              pszCurrent++;
            }
            pszBuffer += ConWriteString(pszBuffer, pszCurrent - pszBuffer);
         }else{
            while (pszBuffer  < pszBufferEnd && !iscntrl(*pszBuffer) ) {
               switch (*(unsigned char *)pszBuffer){
                 case 'l':
                    pszBuffer += ConWriteString("\xda", 1);
                    break;
                 case 'k':
                    pszBuffer += ConWriteString("\xbf", 1);
                    break;
                 case 'm':
                    pszBuffer += ConWriteString("\xc0", 1);
                    break;
                 case 'j':
                    pszBuffer += ConWriteString("\xd9", 1);
                 case 'q':
                    pszBuffer += ConWriteString("\xc4", 1);
                    break;
                 case 'x':
                    pszBuffer += ConWriteString("\xb3", 1);
                    break;
                 case 'n':
                    pszBuffer += ConWriteString("\xc5", 1);
                    break;
                 case '~':
                    pszBuffer += ConWriteString("\xfe", 1);
                    break;
                 case 'u':
                    pszBuffer += ConWriteString("\xb4", 1);
                    break;
                 case 't':
                    pszBuffer += ConWriteString("\xc3", 1);
                    break;
                 case 'v':
                    pszBuffer += ConWriteString("\xc1", 1);
                    break;
                 case 'w':
                    pszBuffer += ConWriteString("\xc2", 1);
                    break;
                 default:
                    pszBuffer += ConWriteString(pszBuffer, 1);
                    break;
               }
            }
         }
       break;	  }
	}

	return pszBuffer;
}

// Added by I.Ioannou 06 April, 1997
// Print the buffer until you reach ESC[4i
char* TANSIParser::PrintBuffer(char* pszBuffer, char* pszBufferEnd)
{
	// Check if we have enough characters in buffer.
  if ((pszBufferEnd - pszBuffer) < 4)
		return pszBuffer;
  char *tmpChar;

  tmpChar = pszBuffer;
  if ( *tmpChar == 27 )
  {
    tmpChar++;
    if ( *tmpChar == '[' )
    {
      tmpChar++;
      if ( *tmpChar == '4' )
      {
        tmpChar++;
        if ( *tmpChar == 'i' )
        {
            InPrintMode = 0; // Stop Print Log
            if ( printfile != NULL )
               fclose(printfile);
            pszBuffer += 4;
            return pszBuffer;
        }
      }
    }
  }

  if (printfile != NULL)
  {
     fputc( *pszBuffer, printfile);
     pszBuffer++;
  }
  else
    InPrintMode = 0;

	return pszBuffer;
}