///////////////////////////////////////////////////////////////////
//      Key translations - I.Ioannou (roryt@hol.gr)              //
//          Athens - Greece    December 18, 1996 02:56am         //
//          Reads a .cfg file and keeps the definitions          //
///////////////////////////////////////////////////////////////////
//                class KeyTranslator                            //
//  Load          : loads or replaces the keymap                 //
//  TranslateKey  : returns a char * to the key def              //
//  AddKeyDef     : Changes or adds the key translation          //
//  DeleteKeyDef  : Deletes a key def from the list              //
///////////////////////////////////////////////////////////////////


#include <windows.h>
#include <fstream.h>
#include <classlib\arrays.h>
#include <mem.h>
#include "keytrans.h"


TArrayAsVector<TKeyDef> keys(0,0,sizeof(TKeyDef));
TArrayAsVector<TKeyDef> globals(0,0,sizeof(TKeyDef));



/////////////////////////////////////////////////////////
//     Class TkeyDef - Key Definitions                 //
//                   - keeped in an array container    //
/////////////////////////////////////////////////////////

TKeyDef::TKeyDef()
{
  szKeyDef = NULL;
  vk_code = dwState = 0;
}

TKeyDef::TKeyDef(char * def, DWORD state, DWORD code)
{
  szKeyDef = NULL;
  if ( def != NULL )
  {
    szKeyDef = (char *) GlobalAlloc(GPTR, strlen(def) +1);
    strcpy(szKeyDef, def);
  }
  dwState = state;
  vk_code = code;
}

TKeyDef::~TKeyDef()
{
/*  if ( szKeyDef != NULL )
  {
    GlobalFree(HGLOBAL(szKeyDef));
  }
  szKeyDef = NULL;
  dwState = vk_code = 0;
*/
}

char * TKeyDef::GetszKey()
{
  return szKeyDef;
}

DWORD  TKeyDef::GetCodeKey()
{
  return vk_code;
}

char * TKeyDef::operator=(char * def)
{
  if ( szKeyDef != NULL )
  {
    strcpy(szKeyDef, def);
  }
  return szKeyDef;
}

DWORD TKeyDef::operator=(DWORD code)
{
 return vk_code = code;
}

int   TKeyDef::operator==(TKeyDef & t)
{
  return ((vk_code == t.vk_code) && (dwState == t.dwState));
}


/////////////////////////////////////////////////////////////
//                class KeyTranslator                      //
//  Load          : loads or replaces the keymap           //
//  TranslateKey  : returns a sz to the key def            //
//  AddKeyDef     : Changes or adds the key translation    //
//  DeleteKeyDef  : Deletes a key def from the list        //
/////////////////////////////////////////////////////////////


KeyTranslator::KeyTranslator()
{
};

#include <stdio.h>
char * KeyTranslator::TranslateKey(WORD wVirtualKeyCode, DWORD dwControlKeyState)
{
  if ( keys.IsEmpty() )
     return NULL;

  int i = keys.Find(TKeyDef(NULL, dwControlKeyState, wVirtualKeyCode));
  if ( i != INT_MAX)
     return keys[i].GetszKey();
  return NULL;
}


int KeyTranslator::AddKeyDef(WORD wVirtualKeyCode, DWORD dwControlKeyState,
                             char*lpzKeyDef)
{
  if ( ! keys.IsEmpty() )
  {
    int i = keys.Find(TKeyDef(NULL, dwControlKeyState, wVirtualKeyCode));
    if ( i != INT_MAX)
    {
      keys[i] = lpzKeyDef;
      return 1;
    }
  }
  return keys.Add( TKeyDef(lpzKeyDef, dwControlKeyState, wVirtualKeyCode));
}

int KeyTranslator::AddGlobalDef(WORD wVirtualKeyCode, char*lpzKeyDef)
{
  if ( ! globals.IsEmpty() )
  {
    int max = globals.GetItemsInContainer();
    for ( int i = 0; i < max ; i++ )
    {
      char * s = globals[i].GetszKey();
      if ( stricmp(s, lpzKeyDef) == 0 )
      {
        globals[i] = DWORD(wVirtualKeyCode);
        return 1;
      }
    }
  }
  return globals.Add( TKeyDef(lpzKeyDef, 0, wVirtualKeyCode));
}


int KeyTranslator::DeleteKeyDef(WORD wVirtualKeyCode, DWORD dwControlKeyState)
{
  if ( keys.IsEmpty() )
     return 0;

  int i = keys.Find(TKeyDef(NULL, dwControlKeyState, wVirtualKeyCode));
  if ( i != INT_MAX)
  {
    keys.Destroy(i);
    return 1;
  }
  return 0;
};

void KeyTranslator::DeleteAllDefs(void)
{
  int max = globals.GetItemsInContainer();
  if ( max )
    for ( int i = 0; i < max; i++ )
        globals.Destroy(i);
  max = keys.GetItemsInContainer();
  if ( ! keys.IsEmpty() )
    for ( int i = 0; i < max; i++ )
        keys.Destroy(i);
//  Added by Brad Johnson 1/16/97
  globals.Flush();
  keys.Flush();
/////////
}


DWORD KeyTranslator::Fix_ControlKeyState(char * Next_Token)
{
  DWORD state = 0;

  if ( stricmp(Next_Token, "RIGHT_ALT" ) == 0)
    state = state | RIGHT_ALT_PRESSED;
  else
  if ( stricmp(Next_Token, "LEFT_ALT" ) == 0)
    state = state | LEFT_ALT_PRESSED;
  else
  if ( stricmp(Next_Token, "RIGHT_CTRL" )  == 0)
    state = state | RIGHT_CTRL_PRESSED;
  else
  if ( stricmp(Next_Token, "LEFT_CTRL" )  == 0)
    state = state | LEFT_CTRL_PRESSED;
  else
  if ( stricmp(Next_Token, "SHIFT" )  == 0)
    state = state | SHIFT_PRESSED;
  else
  if ( stricmp(Next_Token, "NUMLOCK" )  == 0)
    state = state | NUMLOCK_ON;
  else
  if ( stricmp(Next_Token, "SCROLLLOCK" )  == 0)
    state = state | SCROLLLOCK_ON;
  else
  if ( stricmp(Next_Token, "CAPSLOCK" )  == 0)
    state = state | CAPSLOCK_ON;
  else
  if ( stricmp(Next_Token, "ENHANCED" )  == 0)
    state = state | ENHANCED_KEY;
  return state;
}

char*  KeyTranslator::Fix_Tok(char * tok)
{
  static char s[256], s1[4];
  int i,j,n;

  setmem(s, 256, 0);
  i = j = n = 0;
  if ( tok != NULL )
  {
    for ( ; tok[i] != 0; )
    {
      switch ( tok[i] )
      {
         case '\\' :
                    s1[0] = tok[i+1];
                    s1[1] = tok[i+2];
                    s1[2] = tok[i+3];
                    s1[3] = 0;
                    n=atoi(s1);
                    // added the possability for a null character...
                    if ( (n >= 0) && (n<= 255) && (isdigit(s1[0])) )
                    {
                      s[j++]=n;
                      i += 4;
                    }
                    else
                      if ( tok[i+1] == '\\' )
                      {
                        s[j++] = '\\';
                        i += 2;
                      }
                      else
                        s[j++] = tok[i++];
                    break;
         case '^' :
                    if ( tok[i+1] >= '@' )
                    {
                      s[j++] = tok[i+1] - '@';
                      i += 2;
                      break;
                    }
        default  :
                    s[j++] = tok[i++];
      }
    }
  }
  return s;
}

int KeyTranslator::Load( char * filename, char * szActiveEmul)
{
  char buf[256];
  char * Virt_Key, * Next_Token;
  BOOL inGlobal, inEmulation, hadKeys;
  DWORD state, st;

  ifstream inpfile(filename);
  DeleteAllDefs();
  inGlobal = inEmulation = hadKeys = FALSE;
  while ( inpfile )
  {
    hadKeys = TRUE;
    inpfile.getline(buf, 255);
    Virt_Key = strtok(buf, TOKEN_DELIMITERS);
    if ( (Virt_Key != NULL)
         && ( Virt_Key[0] != ';'))
    {
      state = 0;
      Next_Token = NULL;
      int slen = strlen(Virt_Key);
      if ((slen > 1) && (Virt_Key[0] == '[') && (Virt_Key[slen - 1] == ']'))
         inGlobal = inEmulation = FALSE;
      if ( inGlobal || inEmulation )
      {
        for (int i = 0; ; i++)
        {
          Next_Token = strtok(NULL, TOKEN_DELIMITERS);
          if ((inGlobal) ||
              (Next_Token == NULL) ||
              ((st = Fix_ControlKeyState(Next_Token)) == 0))
            break;
         else
           state = state | st;
        }
        if ( Next_Token != NULL )
        {
          if ( inGlobal )
          {
            int i = atoi(Next_Token);
            if ( (i > 0) && (i <= 0xff) )
            {
              if ( ! AddGlobalDef(WORD(i), Virt_Key) )
              {
                hadKeys = FALSE;
                break;
              }
            }
          }
          else
          if ( inEmulation )
          {
            if ( ! globals.IsEmpty() )
            {
              int max = globals.GetItemsInContainer();
              for ( int i = 0; i < max ; i++ )
              {
                char * s = globals[i].GetszKey();
                if ( stricmp(s, Virt_Key) == 0 )
                {
                  char Tok[256];
                  strcpy(Tok, Fix_Tok(Next_Token));
                  if (! AddKeyDef(WORD(globals[i].GetCodeKey()),
                                state, Tok))
                      hadKeys = FALSE;
                  break;
                }
              }
            }
            if ( ! hadKeys )
               break;
          }
        }
      }
      else
      if ( stricmp(Virt_Key, "[GLOBAL]") == 0 )
         inGlobal = TRUE;
      else
      if ( stricmp(Virt_Key, "[END_GLOBAL]") == 0 )
         inGlobal = FALSE;
      else
      {
        char s[256];
        strcpy(s, "[");
        strcat(s, szActiveEmul);
        strcat(s, "]");
        if ( stricmp(Virt_Key, s) == 0 )
            inEmulation = TRUE;
        else
        {
          strcpy(s, "[END_");
          strcat(s, szActiveEmul);
          strcat(s, "]");
          if ( stricmp(Virt_Key, s) == 0 )
              inEmulation = FALSE;
        }
      }
    }
  }
  inpfile.close();
  if ( hadKeys)
     return 1;
  return 0;
}