///////////////////////////////////////////////////////////////////////////////
//Brad Johnson Console Telnet a Win32 ANSI telnet client.
//Copyright (C) 1997  Brad Johnson
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//jbj@chrysalis.org
//brad.johnson@chrysalis.org
//
//Brad Johnson
//P.O. Box 933
//Crowley, TX 76036
//
///////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//
// Module:		tnclass.cpp
//
// Contents:	telnet object definition
//
// Product:		telnet
//
// Revisions: 5.April.1997 jbj@chrysalis.org
//            14.Sept.1996 jbj@chrysalis.org
//            Version 2.0
//
///////////////////////////////////////////////////////////////////////////////

#include "tnclass.h"
#define DEFAULT_KEYMAP "DEFAULT"

#define TNNOCON 0
#define TNPROMPT 1
#define TNSCROLLBACK 2

Telnet::Telnet(char * keyfile, char * szDumpFN){
  Socket = INVALID_SOCKET;
  bConnected = 0;
  bNetPaused = 1;
  bNetPause = 1;
  bNetFinished = 1;
  bNetFinish = 0;
  pcScrollData = new char[20000];
  iScrollSize = 20000;
  iScrollBegin = 0;
  for (int i = 0 ; i < iScrollSize; i++)
    pcScrollData[i] = ' ';
  strncpy(szDumpFileName, szDumpFN, 127);
  WSADATA WsaData;
  telSetConsoleTitle("No Connection");
  if (WSAStartup(MAKEWORD(1, 1), &WsaData)) {
    DWORD dwLastError = GetLastError();
    printm(0, FALSE, MSG_ERROR, "WSAStartup()");
    printm(0, TRUE, dwLastError);
    bWinsockUp = 0;
    return;
  }
  bWinsockUp = 1;
  if(LoadKeyMap( keyfile, DEFAULT_KEYMAP) != 1)
    printf("Error loading keymap.\n");
}

Telnet::Telnet(char * keyfile, char * szHost1, int iPort1, char * szDumpFN){
  Socket = INVALID_SOCKET;
  bConnected = 0;
  bNetPaused = 1;
  bNetPause = 1;
  bNetFinished = 1;
  bNetFinish = 0;
  if (pcScrollData)
    delete [] pcScrollData;
  strncpy(szDumpFileName, szDumpFN, 127);
  telSetConsoleTitle("No Connection");
  WSADATA WsaData;
  if (WSAStartup(MAKEWORD(1, 1), &WsaData)) {
    DWORD dwLastError = GetLastError();
    printm(0, FALSE, MSG_ERROR, "WSAStartup()");
    printm(0, TRUE, dwLastError);
    bWinsockUp = 0;
    return;
  }
  bWinsockUp = 1;
  Open( szHost1, iPort1);
  if(LoadKeyMap( keyfile, DEFAULT_KEYMAP) != 1)
    printf("Error loading keymap.\n");
}

Telnet::~Telnet(){
  if (bWinsockUp){
    Close();
    WSACleanup();
  }
}

int Telnet::LoadKeyMap( char * file, char * name){
  printf("Loading %s from %s.\n", name ,file);
  return KeyMap.Load(file,name);
}

int Telnet::Open(char *szHost1,int iPort1){
  if (bWinsockUp && !bConnected){
    telSetConsoleTitle(szHost1);
    strncpy (szHost,szHost1, 127);
    iPort = iPort1;
    Socket = Connect();
    if (Socket == INVALID_SOCKET) {
      printm(0, FALSE, 0xC0000000 + GetLastError());
      return TNNOCON;
    }
    bNetFinish = 0;
    bConnected = 1;
    ThreadParams.Socket = Socket;
    ThreadParams.bNetPause = &bNetPause;
    ThreadParams.bNetPaused = &bNetPaused;
    ThreadParams.bNetFinish = &bNetFinish;
    ThreadParams.bNetFinished = &bNetFinished;
    ThreadParams.szDumpFileName = szDumpFileName;
    ThreadParams.hExit = CreateEvent(0, TRUE, FALSE, "");
    ThreadParams.pcScrollData = pcScrollData;
    ThreadParams.iScrollSize = &iScrollSize;
    ThreadParams.iScrollBegin = &iScrollBegin;
    DWORD idThread;
    bNetPause = 0;
    HANDLE hThread = CreateThread(0, 0,
      (LPTHREAD_START_ROUTINE) telProcessNetwork,
      (LPVOID)&ThreadParams, 0, &idThread);
    if (hThread) {
      CloseHandle(hThread);
    }
    return Resume();
  }
  return TNNOCON; // cannot do winsock stuff or already connected
}

int Telnet::Close(){
  closesocket(Socket);
  bNetFinish = 1;
  while (!bNetFinished);
  telSetConsoleTitle("No Connection");
  bConnected = 0;
  return 1;
}

int Telnet::Resume(){
  int i;
  if (bConnected) {
    for(;;){
       bNetPause = 0;
       i = telProcessConsole(&ThreadParams);
       if (i) bConnected = 1;
       else bConnected = 0;
       bNetPause = 1;       // pause incoming thread
       while (!bNetPaused); // thread paused
       switch (i){
         case TNNOCON:
           Close();
           return TNNOCON;
         case TNPROMPT:
           return TNPROMPT;
         case TNSCROLLBACK:
           ScrollBack();
           break;
       }
    }
  }
  return TNNOCON;
}


BOOL WriteConsoleOutputCharAndAttribute(
    HANDLE  hConsoleOutput,	// handle of a console screen buffer
    CHAR * lpWriteBuffer,
    WORD wAttrib,
    SHORT sX,
    SHORT sY ){
  LPDWORD  lpcWritten;
  DWORD  cWriteCells = strlen(lpWriteBuffer);
  COORD  coordWrite = {sX,sY};
  LPWORD lpwAttribute = new WORD[cWriteCells];
  for (int i = 0; i < cWriteCells; i++)
    lpwAttribute[i] = wAttrib;
  WriteConsoleOutputAttribute(
    hConsoleOutput,	// handle of a console screen buffer
    lpwAttribute,	// address of buffer to write attributes from
    cWriteCells,	// number of character cells to write to
    coordWrite,	// coordinates of first cell to write to
    lpcWritten 	// address of number of cells written to
    );
  WriteConsoleOutputCharacter(
    hConsoleOutput,	// handle of a console screen buffer
    lpWriteBuffer,	// address of buffer to write characters from
    cWriteCells,	// number of character cells to write to
    coordWrite,	// coordinates of first cell to write to
    lpcWritten 	// address of number of cells written to
   );
  delete [] lpwAttribute;
  return 1;
}




void Telnet::ScrollBack(){
char p;
int r,c;
 #define HEX 0
 #define DUMP 1
 #define TEXTB 2
int iDisplay = DUMP;
//for (r = 0; r < iScrollSize; r++)
//   pcScrollData[r] = r %256;
#define CON_TOP 0
#define CON_BOTTOM (ConsoleInfo.dwSize.Y - 1)
#define CON_LEFT 0
#define CON_RIGHT (ConsoleInfo.dwSize.X - 1)
#define CON_HEIGHT (CON_BOTTOM - CON_TOP)
#define CON_WIDTH (CON_RIGHT - CON_LEFT)
#define CON_LINES (CON_HEIGHT + 1)
#define CON_COLS (CON_WIDTH + 1)

#define CON_CUR_X (DWORD)(ConsoleInfo.dwCursorPosition.X - CON_LEFT)
#define CON_CUR_Y (DWORD)(ConsoleInfo.dwCursorPosition.Y - CON_TOP)

 // save screen to buffer
    CONSOLE_SCREEN_BUFFER_INFO ConsoleInfo;
    HANDLE hStdout;
    SMALL_RECT srctReadRect;
    COORD coordBufSize;
    COORD coordBufCoord;
    BOOL fSuccess;

    hStdout = GetStdHandle(STD_OUTPUT_HANDLE);
    GetConsoleScreenBufferInfo(hStdout, &ConsoleInfo);

    //  buffer to save screen
    CHAR_INFO * chiBuffer;
    chiBuffer = new CHAR_INFO[(CON_BOTTOM-CON_TOP+1)*(CON_RIGHT-CON_LEFT+1)];

    srctReadRect.Top = CON_TOP;    /* top left: row 0, col 0  */
    srctReadRect.Left = CON_LEFT;
    srctReadRect.Bottom = CON_BOTTOM; /* bot. right: row 1, col 79 */
    srctReadRect.Right = CON_RIGHT;

    coordBufSize.Y = CON_BOTTOM-CON_TOP+1;
    coordBufSize.X = CON_RIGHT-CON_LEFT+1;

    coordBufCoord.X = CON_TOP;
    coordBufCoord.Y = CON_LEFT;

    fSuccess = ReadConsoleOutput(
       hStdout,        /* screen buffer to read from       */
       chiBuffer,      /* buffer to copy into              */
       coordBufSize,   /* col-row size of chiBuffer        */

       coordBufCoord,  /* top left dest. cell in chiBuffer */
       &srctReadRect); /* screen buffer source rectangle   */
 // end save screen to buffer

 // paint border and info
    // paint last two lines black on white
    char * szStatusLine;
    szStatusLine = new char[CON_WIDTH+2];
    int i;
    for (i = 0; i <= CON_WIDTH; i++){
      szStatusLine[i]=' ';
    }
    szStatusLine[i] = '\0';
    WriteConsoleOutputCharAndAttribute(
      hStdout,szStatusLine,0xf0,CON_LEFT,CON_BOTTOM);
    WriteConsoleOutputCharAndAttribute(
      hStdout,szStatusLine,0xf0,CON_LEFT,CON_BOTTOM-1);
 // init scroll position
 int current = 0;
 // loop while not done
 BOOL done = FALSE;
   while (!done){
      switch (iDisplay){
         case HEX:
            char t[16];
            char u[16];
            for (r = 0;r < CON_HEIGHT-1; r++){
              for (c = 0; c < 16; c++){
                if (c+(16*(r+current)) > iScrollSize)
                  p = 0;
                else
                  p = pcScrollData[(c+16*(r+current))/* + iScrollBegin) % iScrollSize*/];
                if (!iscntrl(p)){
                  t[c] = (char)p;
                  u[c] = (char)p;
                }
                else{
                  t[c] = (char)p;
                  u[c] = '.';
                }
                sprintf (szStatusLine,"  000000:  %02x %02x %02x %02x %02x %02x %02x %02x-%02x %02x %02x %02x %02x %02x %02x %02x :: %c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c  ",
                     t[0],t[1],t[2],t[3], t[4],t[5],t[6],t[7], t[8],t[9],t[10],t[11], t[12],t[13],t[14],t[15],
                     u[0],u[1],u[2],u[3], u[4],u[5],u[6],u[7], u[8],u[9],u[10],u[11], u[12],u[13],u[14],u[15]);
              }
              szStatusLine[CON_WIDTH+1] = '\0';
              WriteConsoleOutputCharAndAttribute(
                hStdout,szStatusLine,0x0f,CON_LEFT,r+CON_TOP);
            }
            break;
         case DUMP:
            for (r = 0;r < CON_HEIGHT-1; r++){
              for (c = 0; c <= CON_WIDTH; c++){
                if (c+((CON_WIDTH+1)*(r+current)) > iScrollSize) p = ' ';
                else p = pcScrollData[  (c+((CON_WIDTH+1)*(r+current)))/* + iScrollBegin)
                   % iScrollSize*/];
                if (!iscntrl(p))
                  szStatusLine[c] = p;
                else
                  szStatusLine[c] = '.';
              }
              szStatusLine[c] = '\0';
              WriteConsoleOutputCharAndAttribute(
                hStdout,szStatusLine,0x0f,CON_LEFT,r+CON_TOP);
            }
            break;
         case TEXTB:
            for (r = 0;r < CON_HEIGHT-1; r++){
              for (c = 0; c <= CON_WIDTH; c++){
                if (c+((CON_WIDTH+1)*(r+current)) > iScrollSize) p = ' ';
                else p = pcScrollData[  (c+((CON_WIDTH+1)*(r+current)) + iScrollBegin)
                   % iScrollSize];
                if (!iscntrl(p))
                  szStatusLine[c] = p;
                else
                  szStatusLine[c] = '.';
              }
              szStatusLine[c] = '\0';
              WriteConsoleOutputCharAndAttribute(
                hStdout,szStatusLine,0x0f,CON_LEFT,r+CON_TOP);
            }
            break;
      }
      // paint scroll back data
      // get key input
      switch(scrollkeys()){
         case VK_ESCAPE:
           done = TRUE;
           break;
         case VK_PRIOR:
           if ( current > CON_HEIGHT)
             current-= CON_HEIGHT;
           else
             current = 0;
           break;
         case VK_NEXT:
           if ( current < (iScrollSize/CON_WIDTH)-CON_HEIGHT)
             current+= CON_HEIGHT;
           else
             current = (iScrollSize/CON_WIDTH);
           break;
         case VK_DOWN:
           if ( current < iScrollSize / CON_WIDTH) current++;
           break;
         case VK_UP:
           if ( current > 0) current--;
           break;
         case VK_TAB:
           iDisplay = (iDisplay+1)%3;
      }
   }
 // restore screen
    srctReadRect.Top = CON_TOP;    /* top left: row 0, col 0  */
    srctReadRect.Left = CON_LEFT;
    srctReadRect.Bottom = CON_BOTTOM; /* bot. right: row 1, col 79 */
    srctReadRect.Right = CON_RIGHT;

    coordBufSize.Y = CON_BOTTOM-CON_TOP+1;
    coordBufSize.X = CON_RIGHT-CON_LEFT+1;

    coordBufCoord.X = CON_TOP;
    coordBufCoord.Y = CON_LEFT;
    fSuccess = WriteConsoleOutput(
        hStdout, /* screen buffer to write to    */
        chiBuffer,        /* buffer to copy from          */
        coordBufSize,     /* col-row size of chiBuffer    */
        coordBufCoord, /* top left src cell in chiBuffer  */
        &srctReadRect); /* dest. screen buffer rectangle */
 // end restore screen
 delete []szStatusLine;
 delete []chiBuffer;
}

void Telnet::telSetConsoleTitle(char * szHost1)
{
	char szTitle[128];
	wsprintf(szTitle, "Telnet - %s", szHost1);
	SetConsoleTitle(szTitle);
}

SOCKET Telnet::Connect()
{
	printm(0, FALSE, MSG_TRYING);
	SOCKET Socket1 = socket(AF_INET, SOCK_STREAM, 0);
	SOCKADDR_IN SockAddr;
	SockAddr.sin_port = htons((short) iPort);
	SockAddr.sin_family = AF_INET;
	SockAddr.sin_addr.s_addr = inet_addr(szHost);

	// Were we given host name?
	if (SockAddr.sin_addr.s_addr == INADDR_NONE) {

		// Resolve host name to IP address.
		hostent* pHostEnt = gethostbyname(szHost);
		if (!pHostEnt)
			return INVALID_SOCKET;

		SockAddr.sin_addr.s_addr = *(DWORD*)pHostEnt->h_addr;
	}

	if (connect(Socket1, (sockaddr*)&SockAddr, sizeof(SockAddr)))
		return INVALID_SOCKET;

	printm(0, FALSE, MSG_CONNECTED, szHost);

	return Socket1;
}