///////////////////////////////////////////////////////////////////////////////
//Brad Johnson Console Telnet a Win32 ANSI telnet client.
//Copyright (C) 1997  Brad Johnson
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//jbj@chrysalis.org
//brad.johnson@chrysalis.org
//
//Brad Johnson
//P.O. Box 933
//Crowley, TX 76036
//
///////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//
// Module:		tnerror.cpp
//
// Contents:	error reporting
//
// Product:		telnet
//
// Revisions: 5.April.1997 jbj@chrysalis.org
//            5.Dec.1996 jbj@chrysalis.org
//            Version 2.0
//
//            02.Apr.1995	igor.milavec@uni-lj.si
//					  Original code
//
///////////////////////////////////////////////////////////////////////////////

#include "tnerror.h"
#include <time.h>
#include <stdio.h>
#include <stdarg.h>

int Telnet_Redir = 0;
// Telnet_Redir is set to the value of the environment variable TELNET_REDIR
// in main.

int printit( char * it){
  DWORD numwritten;
  if (!Telnet_Redir) {
     if (!WriteConsole(
       GetStdHandle(STD_OUTPUT_HANDLE),	// handle of a console screen buffer
       it,	// address of buffer to write from
       strlen(it),	// number of characters to write
       &numwritten,	// address of number of characters written
       0 	// reserved
       )) return -1;
     }else{
	  if (!WriteFile(
		 GetStdHandle(STD_OUTPUT_HANDLE),	// handle of a console screen buffer
		 it,	// address of buffer to write from
		 strlen(it),	// number of characters to write
   	 &numwritten,	// address of number of characters written
		 NULL // no overlapped I/O
		 )) return -1;
  }
  return 0;
}

int printm(LPTSTR szModule, BOOL fSystem, DWORD dwMessageId, ...)
{
	int Result = 0;

	HMODULE hModule = 0;
	if (szModule)
		hModule = LoadLibrary(szModule);

	va_list Ellipsis;
	va_start(Ellipsis, dwMessageId);

	LPTSTR pszMessage = 0;
	DWORD dwMessage = FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |
		(fSystem? FORMAT_MESSAGE_FROM_SYSTEM: FORMAT_MESSAGE_FROM_HMODULE),
		hModule, dwMessageId, LANG_USER_DEFAULT,
		(LPTSTR)&pszMessage, 128, &Ellipsis);

	va_end(Ellipsis);

	if (szModule)
		FreeLibrary(hModule);

	if (dwMessage) {

		Result = printit(pszMessage);
		LocalFree(pszMessage);
	}

	return Result;
}


void LogErrorConsole(LPTSTR szError)
{
	DWORD dwLastError = GetLastError();

	const int cbLastError = 1024;
	TCHAR szLastError[cbLastError];
	FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, 0, dwLastError, LANG_USER_DEFAULT,
		szLastError, cbLastError, 0);

	LPTSTR lpszStrings[2];
	lpszStrings[0] = szError;
	lpszStrings[1] = szLastError;

	const int cbErrorString = 1024;
	TCHAR szErrorString[cbErrorString];
	FormatMessage(FORMAT_MESSAGE_FROM_HMODULE| FORMAT_MESSAGE_ARGUMENT_ARRAY,
		0, MSG_ERROR, LANG_USER_DEFAULT,
		szErrorString, cbErrorString, (va_list*)lpszStrings);

	time_t dwTime;
	time(&dwTime);
	char* szTime = ctime(&dwTime);
	szTime[19] = 0;

//	printf("E %s %s", szTime + 11, szErrorString);
   char * buf;
   buf = new char [ 3 + strlen(szTime) - 11 + strlen(szErrorString) + 5 ];
	sprintf( buf,"E %s %s", szTime + 11, szErrorString);
   printit(buf);
   delete [] buf;
}


void LogWarningConsole(DWORD dwEvent, LPTSTR szWarning)
{
	DWORD dwLastError = GetLastError();

	const int cbLastError = 1024;
	TCHAR szLastError[cbLastError];
	FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, 0, dwLastError, LANG_USER_DEFAULT,
		szLastError, cbLastError, 0);

	LPTSTR lpszStrings[2];
	lpszStrings[0] = szWarning;
	lpszStrings[1] = szLastError;

	const int cbWarningString = 1024;
	TCHAR szWarningString[cbWarningString];
	FormatMessage(FORMAT_MESSAGE_FROM_HMODULE| FORMAT_MESSAGE_ARGUMENT_ARRAY,
		0, dwEvent, LANG_USER_DEFAULT,
		szWarningString, cbWarningString, (va_list*)lpszStrings);

	time_t dwTime;
	time(&dwTime);
	char* szTime = ctime(&dwTime);
	szTime[19] = 0;

//	printf("W %s %s", szTime + 11, szWarningString);
   char * buf;
   buf = new char [ 3 + strlen(szTime) - 11 + strlen(szWarningString) + 5 ];
	sprintf(buf ,"W %s %s", szTime + 11, szWarningString);
   printit(buf);
   delete [] buf;

}


void LogInfoConsole(DWORD dwEvent, LPTSTR szInformation)
{
	LPTSTR lpszStrings[1];
	lpszStrings[0] = szInformation;

	const int cbInfoString = 1024;
	TCHAR szInfoString[cbInfoString];
	FormatMessage(FORMAT_MESSAGE_FROM_HMODULE| FORMAT_MESSAGE_ARGUMENT_ARRAY,
		0, dwEvent, LANG_USER_DEFAULT,
		szInfoString, cbInfoString, (va_list*)lpszStrings);

	time_t dwTime;
	time(&dwTime);
	char* szTime = ctime(&dwTime);
	szTime[19] = 0;

//	printf("I %s %s", szTime + 11, szInfoString);
   char * buf;
   buf = new char [ 3 + strlen(szTime) - 11 + strlen(szInfoString) + 5 ];
	sprintf(buf,"I %s %s", szTime + 11, szInfoString);
   printit(buf);
   delete [] buf;

}

