///////////////////////////////////////////////////////////////////////////////
//Brad Johnson Console Telnet a Win32 ANSI telnet client.
//Copyright (C) 1997  Brad Johnson
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//jbj@chrysalis.org
//brad.johnson@chrysalis.org
//
//Brad Johnson
//P.O. Box 933
//Crowley, TX 76036
//
///////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//
// Module:		tnmain.cpp
//
// Contents:	telnet main program
//
// Product:		telnet
//
// Revisions: 5.April.1997 jbj@chrysalis.org
//            5.Dec.1996 jbj@chrysalis.org
//            Version 2.0
//
//            02.Apr.1995	igor.milavec@uni-lj.si
//					  Original code
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>
#include <locale.h>
#include "tnmain.h"

#define ENV_TELNET_CFG "TELNET_CFG"
#define ENV_TELNET_REDIR "TELNET_REDIR"


int telCommandLine (Telnet &MyConnection);
BOOL telProcessParameters(int ArgC, char* ArgV[],
   char *szHost, int &iPort, char *params);

void waitforkey(){
   HANDLE hConsole = GetStdHandle(STD_INPUT_HANDLE);
   INPUT_RECORD InputRecord;
	DWORD dwInput;
   BOOL done = FALSE;
   while (!done){
      WaitForSingleObject( hConsole, INFINITE );
      if (!ReadConsoleInput(hConsole, &InputRecord, 1, &dwInput)){
         done = TRUE;
         continue;
         }
      if (InputRecord.EventType == KEY_EVENT &&
          InputRecord.Event.KeyEvent.bKeyDown )
         done = TRUE;

   }
}

char * cfgets ( char * buf, int length, char pszHistory[][80], int iHistLength){
   HANDLE hConsole = GetStdHandle(STD_INPUT_HANDLE);
   int current=0, cursor =0;
   char chr;
   char temp[2];
   char temp1[80];
   int iEraseLength = 0;
   temp[1]=0;
   INPUT_RECORD InputRecord;
   BOOL done = FALSE;
   int h = -1;
   int i;
///
   if(!Telnet_Redir) {
      while (!done) {
         DWORD dwInput;
         WaitForSingleObject( hConsole, INFINITE );
         if (!ReadConsoleInput(hConsole, &InputRecord, 1, &dwInput)){
            done = TRUE;
            continue;
            }
         if (InputRecord.EventType == KEY_EVENT &&
             InputRecord.Event.KeyEvent.bKeyDown ) {
            switch (InputRecord.Event.KeyEvent.wVirtualKeyCode){
              case VK_UP:
                  if (h < iHistLength-1){ h++;
                    strncpy(buf,pszHistory[h],79);
                    current = strlen(buf);
                  }
                  break;
              case VK_DOWN:
                  if (h >= 0) h--;
                  if (h < 0)
                     strncpy(buf,"",79);
                  else
                     strncpy(buf,pszHistory[h],79);
                  current = strlen(buf);
                  break;
              case VK_RIGHT:
                  if (cursor<current){
                   cursor++;
                  }
                  break;
              case VK_LEFT:
                  if (cursor>0) cursor--;
                  break;
              case VK_DELETE:
                  if (current > 0 && current > cursor) {
                     strcpy(&buf[cursor],&buf[cursor+1]);
                     current--;
                     buf[current] = 0;
                     printit("\r");
                     for (i = 0; i < current+strlen("telnet>")+1 ;i++)
                        printit(" ");
                  }
                  break;
              case VK_BACK:
                  if (cursor > 0 ) {
                     strcpy(&buf[cursor-1],&buf[cursor]);
                     current--;
                     cursor--;
                     buf[current] = 0;
                     printit("\r");
                     for (i = 0; i < current+strlen("telnet>")+1 ;i++)
                        printit(" ");
                  }
                  break;

              default:
                  chr = InputRecord.Event.KeyEvent.uChar.AsciiChar;
                  if (chr == '\r') {
                     done = TRUE;
                     continue;
                  }
                  if (current >= length-1){
                     done = TRUE;
                     continue;
                  }
                  if ( isprint (chr) ){
                     strncpy(temp1,&buf[cursor],79);
                     strncpy(&buf[cursor+1],temp1,79-(cursor+1));
                     buf[cursor++]=chr;
                     current++;
                     buf[current] = 0;
                  }
                break;
            }
            printit("\rtelnet");
            for (i = 0; i <= iEraseLength ;i++)
               printit(" ");
            printit("\rtelnet>");
            printit(buf);
            iEraseLength = strlen(buf);
            for (i = 0; i < current-cursor; i++)
               printit("\b");
         }
      }
      buf[current] = 0;
      for (h = iHistLength-1; h > 0; h--)
         strncpy(pszHistory[h],pszHistory[h-1],79);
      strncpy(pszHistory[0],buf,79);
      return buf;
///
	}else{
		WaitForSingleObject( hConsole, INFINITE );
		DWORD dwInput;
		DWORD OldMode;
		GetConsoleMode(hConsole, &OldMode);
		SetConsoleMode(hConsole,
			OldMode &~ (ENABLE_ECHO_INPUT | ENABLE_LINE_INPUT) );
		while (ReadFile(hConsole, &chr, 1, &dwInput, NULL)) {
			if (chr == '\r') {
				temp[0] = chr;
				printit(&temp[0]);
				break;
			}
			if (chr == '\b' && current > 0) {
				current--;
				printit("\b \b");
			}
			if (current >= length-1){
 				break;
			}
			if ( isprint (chr) ){
				temp[0] = chr;
				printit(&temp[0]);
				buf[current++]=chr;
			}
		}
		buf[current] = 0;
		SetConsoleMode(hConsole, OldMode);
		return buf;
	}
}


int main(int ArgC, char* ArgV[])
{

  CONSOLE_SCREEN_BUFFER_INFO  ConsoleScreenBufferInfo;
  GetConsoleScreenBufferInfo(
    GetStdHandle(STD_OUTPUT_HANDLE),
    &ConsoleScreenBufferInfo
  );

  // check to see if the environment variable 'TELNET_REDIR' is not 0;
  {
	 char* p = getenv(ENV_TELNET_REDIR);
	 if (p)
		 Telnet_Redir = atoi(p);
	 if (Telnet_Redir > 1)
		 setlocale(LC_CTYPE,"");
	 // tell isprint() to not ignore local characters, if the environment
	 // variable "LANG" has a valid value (e.g. LANG=de for german characters)
	 // and the file LOCALE.BLL is installed somewhere along the PATH.
  }

  // check to see if there is a key config file environment variable.
  char * k;
  char keyfile[MAX_PATH*2];
  k = getenv(ENV_TELNET_CFG);
  if (k==NULL){                     // if there is no environment variable
     // calculate the path to the key config file
     strncpy(keyfile, ArgV[0],MAX_PATH*2);
     k = strrchr(keyfile, '\\');
     if (k == NULL){                 // if the \ character is not found...
       strcpy(keyfile,"");           // set the path to nothing
     }else{
       k[1] = 0;                     // end the string after the last '\' to get rid of the file name
       if (MAX_PATH*2 >= strlen(keyfile)+strlen("keys.cfg"))
         strcat(keyfile,"keys.cfg"); // add the default filename to the path
       else{
         strcpy(keyfile,"");         // if there is not enough room set the path to nothing
       }
     }
  }else{
    // set the keyfile to the value of the environment variable
    strncpy(keyfile, k,MAX_PATH*2);
  };

  char szHost[128]="";
  char szParams[128]="";
  int iPort = 23;
  char szDumpFileName[128]="";
  printm(0, FALSE, MSG_COPYRIGHT);
  if ( ArgC > 1 && (!strncmp(ArgV[1],"?",1) || !strncmp(ArgV[1],"-?",2) ||
       !strncmp(ArgV[1],"/?",2) ) ){
    printm(0, FALSE, MSG_USAGE);
  }
  else{
     if (! telProcessParameters(ArgC, ArgV, szHost, iPort, szParams)) {
       if (szParams[0]=='d')
          strncpy(szDumpFileName, szParams+1, 127);
       Telnet MyConnection(keyfile, szDumpFileName);
       telCommandLine(MyConnection);
     }
     else{
       if (szParams[0]=='d')
          strncpy(szDumpFileName, szParams+1, 127);
       Telnet MyConnection(keyfile, szDumpFileName);
       if (MyConnection.Open(szHost,iPort)) //still connected
         telCommandLine(MyConnection);
     }
  }
  SetConsoleScreenBufferSize(
    GetStdHandle(STD_OUTPUT_HANDLE),	// handle of console screen buffer
    ConsoleScreenBufferInfo.dwSize 	// new size in character rows and cols.
   );
  SetConsoleWindowInfo(
    GetStdHandle(STD_OUTPUT_HANDLE),	// handle of console screen buffer
    TRUE,	// coordinate type flag
    &ConsoleScreenBufferInfo.srWindow 	// address of new window rectangle
  );
  SetConsoleTextAttribute(
    GetStdHandle(STD_OUTPUT_HANDLE),	// handle of console screen buffer
    ConsoleScreenBufferInfo.wAttributes 	// text and background colors
   );
  return 0;
}

BOOL telProcessParameters(int ArgC, char* ArgV[],
   char *szHost, int &iPort, char *params)
{
  int o=0;
  if (ArgC < 2)
	 return FALSE;
  if ((ArgV[1])[0] =='-'){
    strncpy(params,ArgV[1]+1, 127);
    o=1;
  }
  if (ArgC < 3+o) {
    strncpy( szHost, ArgV[1+o], 127);
    iPort = 23;
  	 return TRUE;
  }
  if (ArgC < 4+o) {
	 strncpy( szHost, ArgV[1+o], 127);
    iPort = (short)atoi( ArgV[2+o] );
  	 return TRUE;
  }
  return TRUE;
}

int telCommandLine (Telnet &MyConnection){
  #define HISTLENGTH 25
  int i;
  char szCmd[80], szArg1[80], szArg2[80];
  char pszHistory[HISTLENGTH][80]; // 10 80 column buffers
  char szCommand[80];
  int bDone = 0;
  for (i=0; i < HISTLENGTH; i++)  // clear history
    pszHistory[i][0]=0;
  while (!bDone){
    printit( "telnet>");
    cfgets ( szCommand, 79 , pszHistory, HISTLENGTH);
    strlwr(szCommand);  // convert command line to lower
    i = sscanf(szCommand,"%80s %80s %80s", szCmd, szArg1, szArg2);
    if (i > 0){
      switch(szCmd[0]){
        case 'c':
          if (!strncmp(szCmd,"close",strlen(szCmd))){
            MyConnection.Close();
            printit( "\n");
          }
          else{
            printm(0, FALSE, MSG_INVCMD);
          }
          break;
        case 'o':
          if (!strncmp(szCmd,"open",strlen(szCmd))){
            if (i < 2){
              printit("\nopen host [port]\n");
              break;
            }
            if (i < 3){
              printit( "\n");
              MyConnection.Open(szArg1, 23);
              break;
            }
            if (i < 4) {
              printit( "\n");
              MyConnection.Open(szArg1,(short)atoi( szArg2 ));
              break;
            }
          }
          else
            printm(0, FALSE, MSG_INVCMD);
          break;
        case 'q':
          if (!strncmp(szCmd,"quit",strlen(szCmd))){
            MyConnection.Close();
            bDone = 1;
          }
          else {
            printm(0, FALSE, MSG_INVCMD);
          }
          break;
        case 'k':
          if (!strncmp(szCmd,"keys",strlen(szCmd))){
            if (i < 2){
              printit("\nkeys keymapname [file]\n");
              break;
            }
            if (i < 3){
              printit( "\n");
              if(MyConnection.LoadKeyMap( "keys.cfg", szArg1) != 1)
                printit("Error loading keymap.\n");
              break;
            }
            if (i < 4){
              printit( "\n");
              if (MyConnection.LoadKeyMap( szArg2, szArg1) != 1)
                printit("Error loading keymap.\n");
              break;
            }
          }
          else {
            printm(0, FALSE, MSG_INVCMD);
          }
          break;
        case '?':
            printit( "\n");
            printm(0, FALSE, MSG_HELP);
          break;
        default:
            printm(0, FALSE, MSG_INVCMD);
          break;
      }
    }
    else{
      printit( "\n");
      MyConnection.Resume();
    }
  }
  return 1;
}
