///////////////////////////////////////////////////////////////////////////////
//Brad Johnson Console Telnet a Win32 ANSI telnet client.
//Copyright (C) 1997  Brad Johnson
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//jbj@chrysalis.org
//brad.johnson@chrysalis.org
//
//Brad Johnson
//P.O. Box 933
//Crowley, TX 76036
//
///////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//
// Module:		tnnet.cpp
//
// Contents:	telnet network functions
//
// Product:		telnet
//
// Revisions: 14.Sept.1996 jbj@chrysalis.org
//            Version 2.0
//            02.Apr.1995	igor.milavec@uni-lj.si
//					  Original code
//
///////////////////////////////////////////////////////////////////////////////

#include "tnnet.h"
#include "tnparser.h"

DWORD telProcessNetwork(LPVOID pvParams)
{
	TelThreadParams* pParams = (TelThreadParams*)pvParams;
	SOCKET Socket = pParams->Socket;
   TTelnetParser *Parser;
	Parser = new TTelnetParser(GetStdHandle(STD_OUTPUT_HANDLE), Socket,
      pParams->szDumpFileName, pParams->pcScrollData, *pParams->iScrollSize, pParams->iScrollBegin);
  if (!Parser){
//    printf("could not create telnet parser!");
    return 0;
  }
  *pParams->bNetFinished = 0;
	const DWORD dwBuffer = 1024*4;
	char szBuffer[dwBuffer];
	char* pszHead = szBuffer;
	char* pszTail = szBuffer;
	while (!*pParams->bNetFinish) {
    // Get data from Socket
    *pParams->bNetPaused = 1;  //Pause
    int Result = recv(Socket, pszTail, (szBuffer + dwBuffer) - pszTail, 0);
      while(*pParams->bNetPause && !*pParams->bNetFinish) *pParams->bNetPaused = 1;  //Pause
    *pParams->bNetPaused = 0;  //UnPause
    if (Result <= 0 || Result > dwBuffer ){
      break;
    }
    pszTail += Result;

    // Process the buffer
    char* pszNewHead = pszHead;
    do {
      while(*pParams->bNetPause && !*pParams->bNetFinish) *pParams->bNetPaused = 1;  //Pause
      *pParams->bNetPaused = 0;  //UnPause
      pszHead = pszNewHead;
      pszNewHead = Parser->ParseBuffer(pszHead, pszTail); // Parse buffer
    } while ((pszNewHead != pszHead) && (pszNewHead < pszTail) && !*pParams->bNetFinish);
    pszHead = pszNewHead;

    // When we reach the end of the buffer, move contents to the
    // beginning of the buffer to get free space at the end.
    if (pszTail == (szBuffer + dwBuffer)) {
      MoveMemory(szBuffer, pszHead, pszTail - pszHead);
      pszTail = szBuffer + (pszTail - pszHead);
      pszHead = szBuffer;
    }
	}
	SetEvent(pParams->hExit);
  if (Parser)
    delete Parser;
  printm(0, FALSE, MSG_TERMBYREM);
  *pParams->bNetPaused = 1;  //Pause
  *pParams->bNetFinished = 1;
	return 0;
}

