#include <stdio.h>
#include <math.h>
#include <owl.h>
#include <mdi.h>
#include "tgraf.h"

// Define user commands
#define CM_PRINT 101
#define CM_ABOUT 102

class TM : public TWindow
{
public:
	TGraf* PLOT;
	TM(PTWindowsObject AParent, LPSTR ATitle,PTModule AModule = NULL)
	:TWindow(AParent, ATitle, AModule) {};
	virtual ~TM() { delete PLOT; };
	virtual void SetupWindow(){PLOT = new TGraf(HWindow, 1,1, 100,100);}
	virtual void Paint(HDC PaintDC, PAINTSTRUCT _FAR &PaintInfo);
	virtual void CMPRINT(RTMessage Msg) = [CM_FIRST + CM_PRINT] { PLOT->Print();}
	virtual void CMABOUT(RTMessage Msg) = [CM_FIRST + CM_ABOUT] { PLOT->About();}
};

void TM::Paint(HDC PaintDC, PAINTSTRUCT _FAR &PaintInfo)
{
	TWindow::Paint(PaintDC, PaintInfo);
	RECT rc;
	GetClientRect(HWindow, &rc);
	PLOT->Plot(rc);
}

class TM2 : public TM
{
public:
	TM2(PTWindowsObject AParent, LPSTR ATitle,PTModule AModule = NULL)
	:TM(AParent, ATitle, AModule) {};
	virtual void SetupWindow();
};

void TM2::SetupWindow()
{
	TWindow::SetupWindow();

	PLOT = new TGraf(HWindow, 1,1, 100,100);

	/*IF you want to see the hidden plot,
	  please, comment out the following lines*/

	PLOT->New_Plot();			// Erase previous plot

	PLOT->Set_Titles("Scatter Plot","", "");// Titles
	PLOT->Set_Scale(-100.0,100.0,-100.0,100);   	// User scale (xmin, ymin, xmax, ymax)
	PLOT->Set_Plot_Type(pt_scatter);		// plot type 
	PLOT->Set_X_Label_Format("%10.0f");		// x label format
	PLOT->Set_Y_Label_Format("%10.0f");		// y label format
	PLOT->Set_Tics(10,10,4,4);			// tics (xmajor,xminor,ymajor,yminor)

	//* Add some points

        PLOT->Set_Line_Style(PS_SOLID);			// change line to solid line
	PLOT->Set_Color(pc_yellow);			// change pen color to yellow

	char number[40];				// to hold some string

	for (int i = 0; i<=20;i++){
	int random_number_x = rand() % 200 - 100;
	int random_number_y = rand() % 200 - 100;
	sprintf(number,"No.%i", i);
	PLOT->Add_Point(random_number_x,random_number_y,number);
	};
}


class TM3 : public TM
{
public:
	TM3(PTWindowsObject AParent, LPSTR ATitle,PTModule AModule = NULL)
	:TM(AParent, ATitle, AModule) {};
	virtual void SetupWindow();
};

void TM3::SetupWindow()
{
	TWindow::SetupWindow();

	PLOT = new TGraf(HWindow, 1,1, 100,100);

	/*IF you want to see the hidden plot,
	  please, comment out the following lines*/

	PLOT->New_Plot();			// Erase previous plot
	PLOT->Set_Titles("Results vs. Time","Time(s)", "Results");// Titles
	PLOT->Set_Scale(-100.0,100.0,-100.0,100);   	// User scale (xmin, ymin, xmax, ymax)
	PLOT->Set_Plot_Type(pt_line_dot);		// plot type
	PLOT->Set_X_Label_Format("%10.0f");		// x label format
	PLOT->Set_Y_Label_Format("%10.0f");		// y label format
	PLOT->Set_Tics(10,8,5,5);			// tics (xmajor,xminor,ymajor,yminor)

	/********************************************************
	 Add some points
         *******************************************************/

	PLOT->Set_Color(pc_red);			//change pen color to yellow

        // add a point at -80,-80, and attach text "First Data Set"
	PLOT->Add_Point(-80,-80*cos(4*-100*3.141567/180),"1st Data Set");

        // add points from x=-95 to 5 and _DO NOT_ attach text
	for(double i=-75;i<=-5;i+=5) PLOT->Add_Point(i,i*cos(4*i*3.141567/180));

	//-------------
        //New set;
	PLOT->New_Set();
	PLOT->Set_Color(pc_blue);			// change pen color to blue
	PLOT->Set_Line_Style(PS_DASH);			// change line type to Dash

	// add a point at 0,0, and add text "2nd Data Set"
	PLOT->Add_Point(0,-20 + 0*cos(4*0*3.141567/180),"2nd Data Set");

        // add some more points from x=5 to 95
	for(i=5;i<=95;i+=5) PLOT->Add_Point(i,-20 + i*cos(4*i*3.141567/180));

        //-------------
	PLOT->New_Set();
        PLOT->Set_Color(pc_yellow);			// change pen color to green
	PLOT->Set_Line_Style(PS_DOT);			// change line type to Dot

	// add the last point at 50,50, and attach text "Last Point"
	PLOT->Add_Point(50,50*cos(4*100*3.141567/180),"3rd Data Set");
	for(i=55;i<=100;i+=5) PLOT->Add_Point(i,10 + i*sin(3*i*3.141567/180));
}

class TM4 : public TM
{
public:
	TM4(PTWindowsObject AParent, LPSTR ATitle,PTModule AModule = NULL)
	:TM(AParent, ATitle, AModule) {};
	virtual void SetupWindow();
};

void TM4::SetupWindow()
{
	TWindow::SetupWindow();

	PLOT = new TGraf(HWindow, 1,1, 100,100);

	/*IF you want to see the hidden plot,
	  please, comment out the following lines*/

	PLOT->New_Plot();			// Erase previous plot
	PLOT->Set_Titles("Some Lines","", "Line Styles");// Titles
	PLOT->Set_Scale(-100.0,100.0,-100.0,100);   	// User scale (xmin, ymin, xmax, ymax)
	PLOT->Set_Plot_Type(pt_line);		// plot type
	PLOT->Set_X_Label_Format("%10.0f");		// x label format
	PLOT->Set_Y_Label_Format("%10.0f");		// y label format
	PLOT->Set_Tics(8,8,4,4);			// tics (xmajor,xminor,ymajor,yminor)

	/********************************************************
	 Add some points
         *******************************************************/

	PLOT->Set_Color(pc_red);			//change pen color to yellow
	PLOT->Set_Line_Style(PS_SOLID);
	// add points from x=-100 to 100 and _DO NOT_ attach text
	for(double i=-100;i<=100;i+=10) PLOT->Add_Point(i,10*cos(4*i*3.141567/180)+90);
	//-------------
        //New set;
	PLOT->New_Set();
	PLOT->Set_Color(pc_blue);               	// change pen color to blue
	PLOT->Set_Line_Style(PS_DOT);		
	for(i=-100;i<=100;i+=10) PLOT->Add_Point(i,20*sin(4*i*3.141567/180)+50);
	//-------------
	PLOT->New_Set();
        PLOT->Set_Color(pc_yellow);			// change pen color to green
	PLOT->Set_Line_Style(PS_DASHDOT);
	for(i=-100;i<=100;i+=10) PLOT->Add_Point(i,30*cos(4*i*3.141567/180)+0);
	//-------------
	PLOT->New_Set();
        PLOT->Set_Color(pc_magenta);			// change pen color to green
	PLOT->Set_Line_Style(PS_DASH);
	for(i=-100;i<=100;i+=10) PLOT->Add_Point(i,20*sin(4*i*3.141567/180)-50);
	//-------------
	PLOT->New_Set();
	PLOT->Set_Color(pc_cyan);			// change pen color to green
	PLOT->Set_Line_Style(PS_DASHDOTDOT);
	for(i=-100;i<=100;i+=10) PLOT->Add_Point(i,10*cos(4*i*3.141567/180)-90);
}

// Define a TApplication descendant
class TMDIApp : public TApplication {
public:
    TMDIApp(LPSTR name, HINSTANCE hInstance,
		  HINSTANCE hPrevInstance, LPSTR lpCmd,
		  int nCmdShow)
	        : TApplication(name, hInstance,
			       hPrevInstance, lpCmd, nCmdShow) {};
    virtual void InitMainWindow();
};

// Define a TMDIFrame descendant
class TMyMDIFrame : public TMDIFrame {
public:
  WORD ChildNum;

  TMyMDIFrame(LPSTR ATitle, LPSTR MenuName);
  virtual void SetupWindow();
  virtual PTWindowsObject InitChild();
};

// Construct the TMDIApp's MainWindow object, loading its menu
void TMDIApp::InitMainWindow()
{
  MainWindow = new TMyMDIFrame("TGraf Demo Program","TGRAFDEMOMENU");
}

TMyMDIFrame::TMyMDIFrame(LPSTR ATitle, LPSTR MenuName)
             : TMDIFrame(ATitle, MenuName)
{
  ChildNum = 1;
}

void TMyMDIFrame::SetupWindow()
{
  TMDIFrame::SetupWindow();
  GetApplication()->MakeWindow(new TM4(this,"TGraf User 3"));
  GetApplication()->MakeWindow(new TM3(this,"TGraf User 2"));
  GetApplication()->MakeWindow(new TM2(this,"TGraf User 1"));
  GetApplication()->MakeWindow(new TM(this,"TGraf"));
}

PTWindowsObject TMyMDIFrame::InitChild()
{
  char ChildName[14];
  wsprintf(ChildName,"TGraf", ChildNum++);
  return new TM(this, ChildName);
}

// Run the MDIApp
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
		   LPSTR lpCmd, int nCmdShow)
{
    TMDIApp MDIApp ("MDIApp", hInstance, hPrevInstance,
		lpCmd, nCmdShow);
    MDIApp.Run();
    return (MDIApp.Status);
}

