/*
UNOBFUSC.H

Andrew Schulman
Senior editor, O'Reilly & Associates (Sebastopol CA)
andrew@ora.com

ftp://ftp.ora.com/pub/examples/windows/win95.update/schulman.html

Based on code supplied by Thuan Ewe.

August 1995

In Windows 95, the GetCurrentProcessID() and GetCurrentThreadID()
functions return "obfuscated" IDs.  KERNEL32 takes the actual address
of the data structure and XORs it with a magic number to generate the
value returned from GetCurrentXXXID().  This module contains
TIDToTDB() and PIDToPDB() to turn the values returned from these 
functions back into addresses of the data structures.

See UNOBFUSC.C for details

To do:
Need structure for Ring 3 TCB; also use to verify that TIDToTDB works!
*/

struct PDB_t {      // thanks, Thuan!!
  DWORD Type;  DWORD Refcount;
  DWORD Unk1;  DWORD Unk2;
  DWORD TermStatus;  DWORD Unk3;
  DWORD DefaultHeap;  DWORD MemContext;
  DWORD Flags;  DWORD pPsp;
  WORD PSPSelector;  WORD MTEIndex;  
  WORD nThreads;  WORD nThreadsNotTerm;
  WORD Unk5;  WORD nROThreads;  DWORD PtrUnk3;
  WORD K16TDBSel;  WORD Unk6;  DWORD Unk7;
  DWORD pEDB;  DWORD pHandleTable;
  struct PDB_t *ParentPDB;  DWORD MODREFList;
  DWORD ThreadList;  DWORD Unk8;
  DWORD Unk9;  DWORD Unk10;
  DWORD Z4Unk11;  DWORD Unk12;
  DWORD Unk13;  DWORD Unk14;
  DWORD Z1Unk15;
  } ;

DWORD WINAPI PIDToPDB(DWORD pid);

struct PDB_t * WINAPI PIDToPDBStruct(DWORD pid);

DWORD WINAPI TIDToTDB(DWORD tid);

