// vogonvw.cpp : implementation of the CVogonView class
//

#include "stdafx.h"
#include "vogon.h"

#include "CntrInfo.h"
#include "CntrItem.h"
#include "vogondoc.h"
#include "vogonvw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVogonView

IMPLEMENT_DYNCREATE(CVogonView, CView)

BEGIN_MESSAGE_MAP(CVogonView, CView)
   //{{AFX_MSG_MAP(CVogonView)
   ON_WM_SETFOCUS()
   ON_WM_SIZE()
   ON_COMMAND(ID_VIEW_WEBSTER, OnInsertWebster)
   ON_COMMAND(ID_VIEW_ABOUTWEBSTER, OnAboutWebster)
	ON_COMMAND(ID_SHOW_PROPERTY_INSPECTOR, OnShowPropertyInspector)
	ON_UPDATE_COMMAND_UI(ID_SHOW_PROPERTY_INSPECTOR, OnUpdateShowPropertyInspector)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ABOUTWEBSTER, OnUpdateViewAboutwebster)
	ON_COMMAND(ID_VIEW_ACTIVATE, OnActivateWebster)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SLIDESHOW, OnUpdateSlideShow)
	ON_COMMAND(ID_VIEW_SLIDESHOW, OnSlideShow)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVogonView construction/destruction

CVogonView::CVogonView()
{
   // TODO: add construction code here
   m_pSelection    = NULL;
   m_idTimerSlides = 0;
}

CVogonView::~CVogonView()
{
}

/////////////////////////////////////////////////////////////////////////////
// CVogonView drawing

void CVogonView::OnDraw(CDC* pDC)
{
   CVogonDoc* pDoc = GetDocument();
   ASSERT_VALID(pDoc);

   // TODO: add draw code for native data here
   // TODO: also draw all OLE items in the document

   // Draw the selection at an arbitrary position.  This code should be
   //  removed once your real drawing code is implemented.  This position
   //  corresponds exactly to the rectangle returned by CVogonCntrItem,
   //  to give the effect of in-place editing.

   // TODO: remove this code when final draw code is complete.
#ifdef NOTNOW
   if (m_pSelection == NULL)
   {
      POSITION pos = pDoc->GetStartPosition();
      m_pSelection = (CVogonCntrItem*)pDoc->GetNextClientItem(pos);
   }
   if (m_pSelection != NULL)
      m_pSelection->Draw(pDC, CRect(10, 10, 210, 210));
#endif // NOTNOW
}

/////////////////////////////////////////////////////////////////////////////
// CVogonView drawing
void CVogonView::OnInitialUpdate()
{
   POSITION pos = GetDocument()->GetStartPosition();
   if (pos)
   {  // Have at least one item:
      CVogonCntrItem* pItem = (CVogonCntrItem*) GetDocument()->GetNextItem(pos);
      // Select the lone item
      m_pSelection = pItem;
      // Cannot activate here due to hook problems
      PostMessage(WM_COMMAND, ID_VIEW_ACTIVATE, 0);
   }
   else
   {  // Need to create the control:
      m_pSelection = NULL;    // initialize selection
      // Cannot call OnInsertWebster() from here, it messes up CMainFrame menu handling:
      PostMessage(WM_COMMAND, ID_VIEW_WEBSTER, 0);
   }

   CView::OnInitialUpdate();
}

/////////////////////////////////////////////////////////////////////////////
// OLE Client support and commands

BOOL CVogonView::IsSelected(const CObject* pDocItem) const
{
   // The implementation below is adequate if your selection consists of
   //  only CVogonCntrItem objects.  To handle different selection
   //  mechanisms, the implementation here should be replaced.

   // TODO: implement this function that tests for a selected OLE client item

   return pDocItem == m_pSelection;
}

// Special handling of OnSetFocus and OnSize are required for a container
//  when an object is being edited in-place.
void CVogonView::OnSetFocus(CWnd* pOldWnd)
{
   COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
   if (pActiveItem != NULL &&
      pActiveItem->GetItemState() == COleClientItem::activeUIState)
   {
      // need to set focus to this item if it is in the same view
      CWnd* pWnd = pActiveItem->GetInPlaceWindow();
      if (pWnd != NULL)
      {
         pWnd->SetFocus();   // don't call the base class
         return;
      }
   }

   // CView::OnSetFocus(pOldWnd);
}

void CVogonView::OnSize(UINT nType, int cx, int cy)
{
   // Autosize to the view
   if (m_pSelection && m_pSelection->IsInPlaceActive())
   {  // We have a control
      m_pSelection->SetItemRects(CRect(0, 0, cx, cy));
   }
}

/////////////////////////////////////////////////////////////////////////////
// CVogonView diagnostics

#ifdef _DEBUG
void CVogonView::AssertValid() const
{
   CView::AssertValid();
}

void CVogonView::Dump(CDumpContext& dc) const
{
   CView::Dump(dc);
}

CVogonDoc* CVogonView::GetDocument() // non-debug version is inline
{
   ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CVogonDoc)));
   return (CVogonDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CVogonView message handlers

/////////////////////////////////////////////////////////////////////////////
//
void CVogonView::OnInsertWebster() 
{
   if (GetDocument()->GetStartPosition() == NULL)
   {  // Insert the webster control
      BeginWaitCursor();

      CVogonCntrItem* pItem = NULL;
      TRY
      {  // Create new item connected to our document.
         CVogonDoc* pDoc = GetDocument();
         ASSERT_VALID(pDoc);
         pItem = new CVogonCntrItem(pDoc);
         ASSERT_VALID(pItem);
         // Translate the registry key to an OLE class ID
         CLSID classID;
         HRESULT hRes = CLSIDFromString((LPSTR) (LPCSTR) _T("WEBSTER.WebsterCtrl.1"), &classID);
         TRACE("CLSIDFromString status = %d\n", hRes);
         // Create the new control item:
         if (!pItem->CreateNewItem(classID))
         {  // "Any exception will do"
            AfxThrowMemoryException();  
         }
         ASSERT_VALID(pItem);
         // Allow the server to refresh and size itself:
         pItem->UpdateLink();
         // As an arbitrary user interface design, this sets the selection
         //  to the last item inserted.
         m_pSelection = pItem;
         // Have a window - activate
         OnActivateWebster();
         // Refresh
         Invalidate();
         // Tell Webster who we are - this will become an HTTP header
         CString stringWhoWeAre;
         stringWhoWeAre.LoadString(IDP_VOGON_VERSION);
         m_pSelection->m_dWebster.SetBrowserName(stringWhoWeAre);
         // Hide the URL window - we show our own status
         m_pSelection->m_dWebster.SetUrlWindowStyle(0);
      }
      CATCH(CException, e)
      {  // Failure has occured:
         if (pItem != NULL)
         {
            ASSERT_VALID(pItem);
            pItem->Delete();
         }
         m_pSelection = NULL;
         AfxMessageBox(IDP_FAILED_TO_CREATE);
      }
      END_CATCH
      // Done
      EndWaitCursor();
   }
}

/////////////////////////////////////////////////////////////////////////////
// CVogonView message handlers

/////////////////////////////////////////////////////////////////////////////
// 
void CVogonView::OnDestroy() 
{  // We need to kill any timers before the window is gone ..
   if (m_idTimerSlides)
   {  // Had a timer
      KillTimer(m_idTimerSlides);
      // Be polite, clean up ..
      m_idTimerSlides = 0;
      TRACE("OnDestroy found active timer, shutting down\n");
   }
   // Allow base class to do it's thing
   CView::OnDestroy();
}

/////////////////////////////////////////////////////////////////////////////
// 
void CVogonView::OnAboutWebster() 
{
   m_pSelection->m_dWebster.AboutBox();
}

/////////////////////////////////////////////////////////////////////////////
// 
void CVogonView::OnUpdateViewAboutwebster(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable(m_pSelection != NULL);
}

/////////////////////////////////////////////////////////////////////////////
// 
void CVogonView::OnShowPropertyInspector() 
{  // Bring up the property pages
   m_pSelection->DoVerb(OLEIVERB_PRIMARY, this);
}

/////////////////////////////////////////////////////////////////////////////
// 
void CVogonView::OnUpdateShowPropertyInspector(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable(m_pSelection != NULL);
}

/////////////////////////////////////////////////////////////////////////////
// 
void CVogonView::OnActivateWebster() 
{  // Activate-in-place
   doActiveSelection();
   // Size to fit the view
   CRect rectClient;
   GetClientRect(rectClient);
   m_pSelection->SetItemRects(rectClient);
}

/////////////////////////////////////////////////////////////////////////////
// 
void CVogonView::OnUpdateSlideShow(CCmdUI* pCmdUI) 
{
   pCmdUI->SetCheck(m_idTimerSlides);
}

/////////////////////////////////////////////////////////////////////////////
// 
void CVogonView::OnSlideShow() 
{  // Toggle the slide show
   if (m_idTimerSlides)
   {  // Was on - switch off
      KillTimer(m_idTimerSlides);
      m_idTimerSlides = 0;
   }
   else
   {  // Was off - turn on a one-second timer, if any slides present:
      CString stringSlide(GetDocument()->GetFirstSlideName());
      if (!stringSlide.IsEmpty())
      {  // Have slides: set the timer
         m_idTimerSlides = SetTimer(1, 1000, NULL);
         // Remember the start time
         m_timeLastSlide = time(NULL);
         // Set the first slide
         m_pSelection->m_dWebster.SetPageURL(stringSlide);
      }
   }
}

/////////////////////////////////////////////////////////////////////////////
// 
void CVogonView::OnTimer(UINT nIDEvent) 
{
   if (nIDEvent == m_idTimerSlides)
   {  // Our timer: is the time up ?
      CTimeSpan timeSpan = CTime(time(NULL)) - m_timeLastSlide;
      if (timeSpan.GetTotalSeconds() >= GetDocument()->GetSlideInterval())
      {  // Time for the next URL:
         CString stringSlide(GetDocument()->GetNextSlideName());
         // At the end of the list, if no repeat, string will be blank
         if (!stringSlide.IsEmpty())
         {  // Cycle to the next page
            TRACE("Slide (%d sec) is \"%s\"\n", 
                 GetDocument()->GetSlideInterval(), (LPCTSTR) stringSlide);
            m_pSelection->m_dWebster.SetPageURL(stringSlide);
            // Remember the start time
            m_timeLastSlide = time(NULL);
         }
         else
         {  // Toggle off
            KillTimer(m_idTimerSlides);
            m_idTimerSlides = 0;
         }
      }
   }
   else
   {  // Must be for the base class
      CView::OnTimer(nIDEvent);
   }
}

