// vogondoc.cpp : implementation of the CVogonDoc class
//

#include "stdafx.h"
#include "vogon.h"

#include "CntrInfo.h"
#include "CntrItem.h"
#include "Filter.h"
#include "Slides.h"
#include "Links.h"
#include "TextDlg.h"
#include "vogondoc.h"
#include "vogonvw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVogonDoc

IMPLEMENT_DYNCREATE(CVogonDoc, COleDocument)

BEGIN_MESSAGE_MAP(CVogonDoc, COleDocument)
   //{{AFX_MSG_MAP(CVogonDoc)
	ON_COMMAND(ID_VIEW_SLIDESHOW_SETUP, OnSlideShowSetup)
	ON_COMMAND(ID_VIEW_URLFILTER, OnUrlFilter)
	ON_UPDATE_COMMAND_UI(ID_VIEW_URLFILTER, OnUpdateUrlFilter)
	ON_COMMAND(ID_VIEW_REVEALPAGE, OnRevealPage)
	ON_UPDATE_COMMAND_UI(ID_VIEW_REVEALPAGE, OnUpdateRevealPage)
	ON_COMMAND(ID_VIEW_TEXTRETRIEVAL, OnTextRetrieval)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TEXTRETRIEVAL, OnUpdateTextRetrieval)
	ON_COMMAND(ID_VIEW_HYPERLINKS, OnHyperlinks)
	ON_UPDATE_COMMAND_UI(ID_VIEW_HYPERLINKS, OnUpdateHyperlinks)
	//}}AFX_MSG_MAP
   // Enable default OLE container implementation
   ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, COleDocument::OnUpdatePasteMenu)
   ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE_LINK, COleDocument::OnUpdatePasteLinkMenu)
   ON_UPDATE_COMMAND_UI(ID_OLE_EDIT_LINKS, COleDocument::OnUpdateEditLinksMenu)
   ON_COMMAND(ID_OLE_EDIT_LINKS, COleDocument::OnEditLinks)
   ON_UPDATE_COMMAND_UI(ID_OLE_VERB_FIRST, COleDocument::OnUpdateObjectVerbMenu)
   ON_UPDATE_COMMAND_UI(ID_OLE_EDIT_CONVERT, COleDocument::OnUpdateObjectVerbMenu)
   ON_COMMAND(ID_OLE_EDIT_CONVERT, COleDocument::OnEditConvert)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVogonDoc construction/destruction

CVogonDoc::CVogonDoc()
{
   // For most containers, using compound files is a good idea.
   EnableCompoundFile();
   // Default to 60-sec interval for the slide show, with loop
   m_uintInterval = 60;
   m_doLoop       = TRUE;
   // Start out unfiltered
   m_filterURL    = FALSE;
   // TODO: add one-time construction code here
}

CVogonDoc::~CVogonDoc()
{
}

BOOL CVogonDoc::OnNewDocument()
{
   if (!COleDocument::OnNewDocument())
      return FALSE;

   // TODO: add reinitialization code here
   // (SDI documents will reuse this document)

   return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CVogonDoc serialization

void CVogonDoc::Serialize(CArchive& ar)
{
   if (ar.IsStoring())
   {  // Store slide-show items
      ar << m_uintInterval << m_doLoop;
      m_stringSlides.Serialize(ar);
   }
   else
   {  // Load slide-show items
      ar >> m_uintInterval >> m_doLoop;
      m_stringSlides.Serialize(ar);
   }

   // Calling the base class COleDocument enables serialization
   //  of the container document's COleClientItem objects.
   COleDocument::Serialize(ar);
}


/////////////////////////////////////////////////////////////////////////////
// CVogonDoc diagnostics

#ifdef _DEBUG
void CVogonDoc::AssertValid() const
{
   COleDocument::AssertValid();
}

void CVogonDoc::Dump(CDumpContext& dc) const
{
   COleDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CVogonDoc commands
BOOL CVogonDoc::SaveModified() 
{  // We modify too many things, avoid irritating the user.
   return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::OnSlideShowSetup() 
{  // Present the dialog box
   CSlideShowDlg dlgSlideShow;

   // Initialize: interval, loop flag and slide array pointer
   dlgSlideShow.m_uintInterval = m_uintInterval;
   dlgSlideShow.m_doLoop       = m_doLoop;
   dlgSlideShow.m_pSlideList   = &m_stringSlides;

   // Show the current URL in the edit box
   POSITION pos = GetStartPosition();
   
   if (pos)
   {  // Have an item:
      CVogonCntrItem* pItem = (CVogonCntrItem*) GetNextClientItem(pos);
      dlgSlideShow.m_stringSlideName = pItem->m_dWebster.GetPageURL();
   }

   // Show the dialog
   if (dlgSlideShow.DoModal())
   {  // User selected OK: get the results back
      m_uintInterval = dlgSlideShow.m_uintInterval;
      m_doLoop       = dlgSlideShow.m_doLoop;
   }
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::OnUrlFilter() 
{  // Toggle filtering state
   m_filterURL = !m_filterURL;
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::OnUpdateUrlFilter(CCmdUI* pCmdUI) 
{  // Show filtering state
   pCmdUI->SetCheck(m_filterURL);
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::OnRevealPage() 
{
   // Get a pointer to our object - we need to converse with it
   POSITION pos = GetStartPosition();
   if (pos)
   {  // Have an item:
      CVogonCntrItem* pItem = (CVogonCntrItem*) GetNextClientItem(pos);
      // Toggle the hide flag
      pItem->m_dWebster.SetHiddenFlag(pItem->m_dWebster.GetPageURL(), 
                                 !pItem->m_dWebster.GetHiddenFlag(pItem->m_dWebster.GetPageURL()));
   }
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::OnUpdateRevealPage(CCmdUI* pCmdUI) 
{  
   // Get a pointer to our object - we need to talk to it
   POSITION pos = GetStartPosition();
   
   if (pos)
   {  // Have an item:
      CVogonCntrItem* pItem = (CVogonCntrItem*) GetNextClientItem(pos);
      // Read the hide flag, enable if hidden
      pCmdUI->Enable(pItem->m_dWebster.GetHiddenFlag(pItem->m_dWebster.GetPageURL()));
   }
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::OnTextRetrieval() 
{
   // Get a pointer to our object - we need to communicate with it
   POSITION pos = GetStartPosition();
   
   if (pos)
   {  // Have an item:
      CVogonCntrItem* pItem = (CVogonCntrItem*) GetNextClientItem(pos);
      // Show the text retrieval demo dialog
      CTextRetrievalDlg(&pItem->m_dWebster).DoModal();
   }
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::OnUpdateTextRetrieval(CCmdUI* pCmdUI) 
{  
   // If we have a Webster, enable
   pCmdUI->Enable(GetStartPosition() != NULL);
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::OnHyperlinks() 
{  
   // Get a pointer to our object - we need to communicate with it
   POSITION pos = GetStartPosition();
   
   if (pos)
   {  // Have an item:
      CVogonCntrItem* pItem = (CVogonCntrItem*) GetNextClientItem(pos);
      // Do the hyperlink demo
      CHyperlinkDlg dlgHyperlinks(&pItem->m_dWebster);

      // Show the dialog box
      if (dlgHyperlinks.DoModal() == IDOK)
      {  // User says jump: jump
         pItem->m_dWebster.SetPageURL(dlgHyperlinks.m_stringLink);
      }
   }
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::OnUpdateHyperlinks(CCmdUI* pCmdUI) 
{
   // If we have a Webster, enable
   pCmdUI->Enable(GetStartPosition() != NULL);
}

/////////////////////////////////////////////////////////////////////////////
//
// These are the Webster event handlers: they are hand-coded to match reality
//

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::eventDoClickURL(BSTR* SelectedURL, SHORT* Cancel)
{  // User has selected a URL: are we filtering ?
   if (m_filterURL)
   {  // Filter is active: show the URL filter dialog
      CFilterDialog dlgFilter;
      // Set up the URL
      dlgFilter.m_editURL = *((LPCTSTR*) SelectedURL);
      // Let the user decide
      int filterButton = dlgFilter.DoModal();
      if (filterButton == IDOK || filterButton == ID_OK_HIDE)
      {  // Approval: get the latest user-entered value, could be new
         SysReAllocString(SelectedURL, dlgFilter.m_editURL);
         // Should we hide this page ?
         if (filterButton == ID_OK_HIDE)
         {  // No: first cancel this load, which whould be visible
            *Cancel = TRUE;
            // Get a pointer to our object - we need to talk back to it
            POSITION pos = GetStartPosition();
            CVogonCntrItem* pItem = (CVogonCntrItem*) GetNextClientItem(pos);
            // Load the page, invisibly
            pItem->m_dWebster.LoadPage(dlgFilter.m_editURL, TRUE);
         }
      }
      else
      {  // User says Cancel:
         *Cancel = TRUE;
      }
      // Did user check the "Stop Me before I Show Again" box ?
      m_filterURL = !dlgFilter.m_stopShowingMe;
   }
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::eventKeyDown(short* KeyCode, short Shift)
{  // Ignore for now
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonDoc::eventLoadComplete(BSTR* pageURL, short Status)
{  // A page load has completed, visible or not
   TRACE("CVogonDoc::eventLoadComplete(%s, %d)\n", *((LPCTSTR*)  pageURL), (int) Status);
}


