/*
WIN32PSP.C
Win32 app accesses its own real-mode DOS PSP
Using VxDCall0 to make INT 21h (DOS) and INT 31h (DPMI) calls

This version is corrected from the version that appears in my book
*Unauthorized Windows 95* (IDG Books, 1994), pages 533-535.

The file now includes a Win32 version of the Win16 GetSelectorBase API.
This uses the undocumented Win32 VxDCall API to call DPMI function 6.

Now accessing VxDCall via GetK32ProcAddress: see K32EXP.H, K32EXP.C

Andrew Schulman
andrew@ora.com
http://www.ora.com/windows/
ftp://ftp.ora.com/pub/examples/windows/win95.update/schulman.html
September 1995

Sample output (notice that PSPs in Win95 are 120h (288) bytes, 
not 100h (256) bytes): 

Win32 app's PSP (prot mode): 0C67h
PSP base address: 0003A080h
PSP length: 0120h bytes
JFT @ 3A080018h (20 files)
*/

#include <stdlib.h>
#include <stdio.h>
#define  WIN32_LEAN_AND_MEAN
#include "windows.h"
#include "k32exp.h"

#define MSG(s)           MessageBox(0, s, "WIN32PSP", MB_OK)

void fail(const char *s) { MSG(s); exit(1); }

DWORD lsl(WORD sel)
{
    if (! sel) return 0;
    _asm lsl eax, sel
    // retval in EAX
}

DWORD GetSelectorBase(WORD sel)
{
#if 0   
    #define VXDCALL_ORD         1
    #define VWIN32_INT31_CALL   0x2A0029
    #define DPMICall(eax, ecx)  VxDCall(VWIN32_INT31_CALL, (eax), (ecx))
        
    static DWORD (WINAPI *VxDCall)(DWORD srvc, DWORD eax, DWORD ecx) =
        (DWORD (WINAPI *)(DWORD,DWORD,DWORD)) 0;
#endif  
    if (! VxDCall)
        if (! (VxDCall = GetK32ProcAddress(VXDCALL_ORD)))
            return -1;
        
    _asm mov bx, sel
    DPMICall(0x0006, 0);    // DPMI Get Selector Base function
    // put CX:AX return value into EAX
    _asm mov ax, cx
    _asm shl eax, 16
    _asm mov ax, dx
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
    LPSTR lpszCmdLine, int nCmdShow)
{
    char buf[512];
    MEMORY_BASIC_INFORMATION info;
    WORD psp, *pmax;
    DWORD base, *pjft;
    int len;
    
    // init
    if ((VxDCall = GetK32ProcAddress(VXDCALL_ORD)) == 0)
        fail("Can't find VxDCall");
    
    // Call DOS INT 21h function 62h (Get PSP)
    DosCall(0x6200, 0);
    _asm mov psp, bx
    // returns protected-mode selector to PSP
    len = sprintf(buf, "Win32 app's PSP (prot mode): %04Xh\n", psp);

#if 1
    // use Win32 version of GetSelectorBase
    base = GetSelectorBase(psp);
#else
    // Pass prot-mode PSP to DPMI INT 31h function 6 (Get Sel Base)
    _asm mov bx, psp
    DPMICall(0x0006, 0);
    // we're really a 16-bit DPMI client!!
    _asm mov word ptr base+2, cx
    _asm mov word ptr base, dx
#endif      
        
    len += sprintf(buf+len, "PSP base address: %08lXh\n", base);
    // if base is C0FFE780, then real-mode PSP is 3E78h
        
    // Pass prot-mode PSP to LSL (Load Selector Limit) instruction
    len += sprintf(buf+len, "PSP length: %04Xh bytes\n", lsl(psp) + 1);
    // Win32 app PSP is 120h bytes, not 100h!
        
    // Locate JFT, #files
    pmax = (WORD *) (base + 0x32);
    pjft = (DWORD *) (base + 0x34);
    len += sprintf(buf+len, "JFT @ %08lXh (%u files)\n", 
        *pjft, (DWORD) *pmax);
        
    MSG(buf);
    return 0;
}

